/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.sendsms.shorturl;

import io.nagurea.smsupsdk.common.http.post.POSTSMSUpService;
import io.nagurea.smsupsdk.helper.ShortLinkHelper;
import io.nagurea.smsupsdk.helper.json.GsonHelper;
import io.nagurea.smsupsdk.sendsms.arguments.AlertOptionalArguments;
import io.nagurea.smsupsdk.sendsms.arguments.MarketingOptionalArguments;
import io.nagurea.smsupsdk.sendsms.arguments.OptionalArguments;
import io.nagurea.smsupsdk.sendsms.campaignwithlist.CampaignWithListResponse;
import io.nagurea.smsupsdk.sendsms.campaignwithlist.CampaignWithListResultResponse;
import io.nagurea.smsupsdk.sendsms.campaignwithlist.body.ListId;
import io.nagurea.smsupsdk.sendsms.sender.NoSender;
import io.nagurea.smsupsdk.sendsms.shorturl.body.CampaignWithListAndLinksDataBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CampaignWithListAndShortURLService
extends POSTSMSUpService {
    private static final String URL = "/send/lists";
    private static final String SIMULATE_URL = "/simulate";

    public CampaignWithListAndShortURLService(String rootUrl) {
        super(rootUrl);
    }

    public CampaignWithListResponse sendAlert(@NonNull String token, @NonNull String text, @NonNull Set<ListId> lists, @NonNull List<String> links) throws IOException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (lists == null) {
            throw new NullPointerException("lists is marked non-null but is null");
        }
        if (links == null) {
            throw new NullPointerException("links is marked non-null but is null");
        }
        return this.send(false, token, text, lists, AlertOptionalArguments.builder().sender(NoSender.build()).build(), links);
    }

    public CampaignWithListResponse simulateSendAlert(@NonNull String token, @NonNull String text, @NonNull Set<ListId> lists, @NonNull List<String> links) throws IOException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (lists == null) {
            throw new NullPointerException("lists is marked non-null but is null");
        }
        if (links == null) {
            throw new NullPointerException("links is marked non-null but is null");
        }
        return this.send(true, token, text, lists, AlertOptionalArguments.builder().sender(NoSender.build()).build(), links);
    }

    public CampaignWithListResponse sendAlert(@NonNull String token, @NonNull String text, @NonNull Set<ListId> lists, @NonNull AlertOptionalArguments alertOptionalArgument, @NonNull List<String> links) throws IOException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (lists == null) {
            throw new NullPointerException("lists is marked non-null but is null");
        }
        if (alertOptionalArgument == null) {
            throw new NullPointerException("alertOptionalArgument is marked non-null but is null");
        }
        if (links == null) {
            throw new NullPointerException("links is marked non-null but is null");
        }
        return this.send(false, token, text, lists, alertOptionalArgument, links);
    }

    public CampaignWithListResponse simulateSendAlert(@NonNull String token, @NonNull String text, @NonNull Set<ListId> lists, @NonNull AlertOptionalArguments alertOptionalArgument, @NonNull List<String> links) throws IOException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (lists == null) {
            throw new NullPointerException("lists is marked non-null but is null");
        }
        if (alertOptionalArgument == null) {
            throw new NullPointerException("alertOptionalArgument is marked non-null but is null");
        }
        if (links == null) {
            throw new NullPointerException("links is marked non-null but is null");
        }
        return this.send(true, token, text, lists, alertOptionalArgument, links);
    }

    public CampaignWithListResponse sendMarketing(@NonNull String token, @NonNull String text, @NonNull Set<ListId> lists, @NonNull List<String> links) throws IOException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (lists == null) {
            throw new NullPointerException("lists is marked non-null but is null");
        }
        if (links == null) {
            throw new NullPointerException("links is marked non-null but is null");
        }
        return this.send(false, token, text, lists, MarketingOptionalArguments.builder().sender(NoSender.build()).build(), links);
    }

    public CampaignWithListResponse simulateSendMarketing(@NonNull String token, @NonNull String text, @NonNull Set<ListId> lists, @NonNull List<String> links) throws IOException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (lists == null) {
            throw new NullPointerException("lists is marked non-null but is null");
        }
        if (links == null) {
            throw new NullPointerException("links is marked non-null but is null");
        }
        return this.send(true, token, text, lists, MarketingOptionalArguments.builder().sender(NoSender.build()).build(), links);
    }

    public CampaignWithListResponse sendMarketing(@NonNull String token, @NonNull String text, @NonNull Set<ListId> lists, @NonNull MarketingOptionalArguments marketingOptionalArguments, @NonNull List<String> links) throws IOException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (lists == null) {
            throw new NullPointerException("lists is marked non-null but is null");
        }
        if (marketingOptionalArguments == null) {
            throw new NullPointerException("marketingOptionalArguments is marked non-null but is null");
        }
        if (links == null) {
            throw new NullPointerException("links is marked non-null but is null");
        }
        return this.send(false, token, text, lists, marketingOptionalArguments, links);
    }

    public CampaignWithListResponse simulateSendMarketing(@NonNull String token, @NonNull String text, @NonNull Set<ListId> lists, @NonNull MarketingOptionalArguments marketingOptionalArguments, @NonNull List<String> links) throws IOException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (lists == null) {
            throw new NullPointerException("lists is marked non-null but is null");
        }
        if (marketingOptionalArguments == null) {
            throw new NullPointerException("marketingOptionalArguments is marked non-null but is null");
        }
        if (links == null) {
            throw new NullPointerException("links is marked non-null but is null");
        }
        return this.send(true, token, text, lists, marketingOptionalArguments, links);
    }

    private CampaignWithListResponse send(boolean simulate, @NonNull String token, @NonNull String text, @NonNull Set<ListId> lists, @NonNull OptionalArguments optionalArguments, @NonNull List<String> links) throws IOException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (lists == null) {
            throw new NullPointerException("lists is marked non-null but is null");
        }
        if (optionalArguments == null) {
            throw new NullPointerException("optionalArguments is marked non-null but is null");
        }
        if (links == null) {
            throw new NullPointerException("links is marked non-null but is null");
        }
        ShortLinkHelper.checkLinkListAndTextConsistent(links, text);
        String data = new CampaignWithListAndLinksDataBuilder(text, lists, optionalArguments, links).buildData();
        ImmutablePair<Integer, String> response = this.post(this.buildUrl(simulate), token, data);
        CampaignWithListResultResponse responseObject = GsonHelper.fromJson((String)response.getRight(), CampaignWithListResultResponse.class);
        return CampaignWithListResponse.builder().uid(UUID.randomUUID().toString()).statusCode((Integer)response.getLeft()).effectiveResponse(responseObject).build();
    }

    private String buildUrl(boolean simulate) {
        return URL + (simulate ? SIMULATE_URL : "");
    }
}

