/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.sendsms.shorturl;

import io.nagurea.smsupsdk.common.http.post.POSTSMSUpService;
import io.nagurea.smsupsdk.helper.ShortLinkHelper;
import io.nagurea.smsupsdk.helper.json.GsonHelper;
import io.nagurea.smsupsdk.sendsms.arguments.AlertOptionalArguments;
import io.nagurea.smsupsdk.sendsms.arguments.MarketingOptionalArguments;
import io.nagurea.smsupsdk.sendsms.arguments.OptionalArguments;
import io.nagurea.smsupsdk.sendsms.campaign.CampaignResponse;
import io.nagurea.smsupsdk.sendsms.campaign.CampaignResultResponse;
import io.nagurea.smsupsdk.sendsms.sender.NoSender;
import io.nagurea.smsupsdk.sendsms.shorturl.body.CampaignWithLinksDataBuilder;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CampaignWithShortURLService
extends POSTSMSUpService {
    private static final String URL = "/send";
    private static final String SIMULATE_URL = "/simulate";

    public CampaignWithShortURLService(String rootUrl) {
        super(rootUrl);
    }

    public CampaignResponse sendAlert(@NonNull String token, @NonNull String text, @NonNull List<String> links) throws IOException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (links == null) {
            throw new NullPointerException("links is marked non-null but is null");
        }
        return this.send(false, token, text, AlertOptionalArguments.builder().sender(NoSender.build()).build(), links);
    }

    public CampaignResponse simulateSendAlert(@NonNull String token, @NonNull String text, @NonNull List<String> links) throws IOException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (links == null) {
            throw new NullPointerException("links is marked non-null but is null");
        }
        return this.send(true, token, text, AlertOptionalArguments.builder().sender(NoSender.build()).build(), links);
    }

    public CampaignResponse sendAlert(@NonNull String token, @NonNull String text, @NonNull AlertOptionalArguments alertOptionalArgument, @NonNull List<String> links) throws IOException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (alertOptionalArgument == null) {
            throw new NullPointerException("alertOptionalArgument is marked non-null but is null");
        }
        if (links == null) {
            throw new NullPointerException("links is marked non-null but is null");
        }
        return this.send(false, token, text, alertOptionalArgument, links);
    }

    public CampaignResponse simulateSendAlert(@NonNull String token, @NonNull String text, @NonNull AlertOptionalArguments alertOptionalArgument, @NonNull List<String> links) throws IOException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (alertOptionalArgument == null) {
            throw new NullPointerException("alertOptionalArgument is marked non-null but is null");
        }
        if (links == null) {
            throw new NullPointerException("links is marked non-null but is null");
        }
        return this.send(true, token, text, alertOptionalArgument, links);
    }

    public CampaignResponse sendMarketing(@NonNull String token, @NonNull String text, @NonNull List<String> links) throws IOException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (links == null) {
            throw new NullPointerException("links is marked non-null but is null");
        }
        return this.send(false, token, text, MarketingOptionalArguments.builder().sender(NoSender.build()).build(), links);
    }

    public CampaignResponse simulateSendMarketing(@NonNull String token, @NonNull String text, @NonNull List<String> links) throws IOException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (links == null) {
            throw new NullPointerException("links is marked non-null but is null");
        }
        return this.send(true, token, text, MarketingOptionalArguments.builder().sender(NoSender.build()).build(), links);
    }

    public CampaignResponse sendMarketing(@NonNull String token, @NonNull String text, @NonNull MarketingOptionalArguments marketingOptionalArguments, @NonNull List<String> links) throws IOException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (marketingOptionalArguments == null) {
            throw new NullPointerException("marketingOptionalArguments is marked non-null but is null");
        }
        if (links == null) {
            throw new NullPointerException("links is marked non-null but is null");
        }
        return this.send(false, token, text, marketingOptionalArguments, links);
    }

    public CampaignResponse simulateSendMarketing(@NonNull String token, @NonNull String text, @NonNull MarketingOptionalArguments marketingOptionalArguments, @NonNull List<String> links) throws IOException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (marketingOptionalArguments == null) {
            throw new NullPointerException("marketingOptionalArguments is marked non-null but is null");
        }
        if (links == null) {
            throw new NullPointerException("links is marked non-null but is null");
        }
        return this.send(true, token, text, marketingOptionalArguments, links);
    }

    private CampaignResponse send(boolean simulate, @NonNull String token, @NonNull String text, @NonNull OptionalArguments optionalArguments, @NonNull List<String> links) throws IOException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (optionalArguments == null) {
            throw new NullPointerException("optionalArguments is marked non-null but is null");
        }
        if (links == null) {
            throw new NullPointerException("links is marked non-null but is null");
        }
        ShortLinkHelper.checkLinkListAndTextConsistent(links, text);
        String data = new CampaignWithLinksDataBuilder(text, optionalArguments, links).buildData();
        ImmutablePair<Integer, String> response = this.post(this.buildUrl(simulate), token, data);
        CampaignResultResponse responseObject = GsonHelper.fromJson((String)response.getRight(), CampaignResultResponse.class);
        return CampaignResponse.builder().uid(UUID.randomUUID().toString()).statusCode((Integer)response.getLeft()).effectiveResponse(responseObject).build();
    }

    private String buildUrl(boolean simulate) {
        return URL + (simulate ? SIMULATE_URL : "");
    }
}

