/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.sendsms.shorturl.body;

import io.nagurea.smsupsdk.sendsms.arguments.Delay;
import io.nagurea.smsupsdk.sendsms.arguments.PushType;
import io.nagurea.smsupsdk.sendsms.campaign.body.Message;
import io.nagurea.smsupsdk.sendsms.sender.Sender;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class MessageWithLinks
extends Message {
    private final List<String> links = new ArrayList<String>();

    private MessageWithLinks(String text, PushType pushtype, Sender sender, String delay, String gsmsmsid, Integer unicode, @NonNull List<String> links) {
        super(text, pushtype, sender, delay, gsmsmsid, unicode);
        if (links == null) {
            throw new NullPointerException("links is marked non-null but is null");
        }
        this.links.addAll(links);
    }

    public static MessageWithLinksBuilder builder() {
        return new MessageWithLinksBuilder();
    }

    public List<String> getLinks() {
        return this.links;
    }

    public static class MessageWithLinksBuilder
    extends Message.MessageBuilder {
        private String text;
        private PushType pushtype;
        private Sender sender;
        private String gsmsmsid;
        private Integer unicode;
        private List<String> links;
        private String delay;

        @Override
        public MessageWithLinksBuilder delay(Delay delay) {
            if (delay != null) {
                this.delay = delay.getValue();
            }
            return this;
        }

        MessageWithLinksBuilder() {
        }

        @Override
        public MessageWithLinksBuilder text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public MessageWithLinksBuilder pushtype(PushType pushtype) {
            this.pushtype = pushtype;
            return this;
        }

        @Override
        public MessageWithLinksBuilder sender(Sender sender) {
            this.sender = sender;
            return this;
        }

        @Override
        public MessageWithLinksBuilder gsmsmsid(String gsmsmsid) {
            this.gsmsmsid = gsmsmsid;
            return this;
        }

        @Override
        public MessageWithLinksBuilder unicode(Integer unicode) {
            this.unicode = unicode;
            return this;
        }

        public MessageWithLinksBuilder links(@NonNull List<String> links) {
            if (links == null) {
                throw new NullPointerException("links is marked non-null but is null");
            }
            this.links = links;
            return this;
        }

        @Override
        public MessageWithLinks build() {
            return new MessageWithLinks(this.text, this.pushtype, this.sender, this.delay, this.gsmsmsid, this.unicode, this.links);
        }

        public String toString() {
            return "MessageWithLinks.MessageWithLinksBuilder(text=" + this.text + ", pushtype=" + this.pushtype + ", sender=" + this.sender + ", delay=" + this.delay + ", gsmsmsid=" + this.gsmsmsid + ", unicode=" + this.unicode + ", links=" + this.links + ")";
        }
    }
}

