/*
 * Decompiled with CFR 0.152.
 */
package io.nagurea.smsupsdk.sendsms.singlemessage;

import io.nagurea.smsupsdk.common.e164.E164Helper;
import io.nagurea.smsupsdk.common.exception.RequiredParameterException;
import io.nagurea.smsupsdk.common.http.SMSUpURLEncoder;
import io.nagurea.smsupsdk.common.http.get.GETSMSUpService;
import io.nagurea.smsupsdk.helper.json.GsonHelper;
import io.nagurea.smsupsdk.sendsms.arguments.AlertOptionalArguments;
import io.nagurea.smsupsdk.sendsms.arguments.MarketingOptionalArguments;
import io.nagurea.smsupsdk.sendsms.arguments.OptionalArguments;
import io.nagurea.smsupsdk.sendsms.sender.NoSender;
import io.nagurea.smsupsdk.sendsms.singlemessage.SingleMessageResponse;
import io.nagurea.smsupsdk.sendsms.singlemessage.SingleMessageResultResponse;
import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class SingleMessageService
extends GETSMSUpService {
    private static final String URL = "/send";
    private static final String TO = "to";
    private static final String SIMULATE_URL = "/simulate";
    private static final boolean SIMULATE = true;
    private static final boolean DO_NOT_SIMULATE = false;

    public SingleMessageService(String rootUrl) {
        super(rootUrl);
    }

    public SingleMessageResponse sendAlert(String token, String text, String to) throws IOException {
        return this.send(false, token, text, to, AlertOptionalArguments.builder().sender(NoSender.build()).build());
    }

    public SingleMessageResponse simulateSendAlert(String token, String text, String to) throws IOException {
        return this.send(true, token, text, to, AlertOptionalArguments.builder().sender(NoSender.build()).build());
    }

    public SingleMessageResponse sendAlert(String token, String text, String to, @NonNull AlertOptionalArguments alertOptionalArguments) throws IOException {
        if (alertOptionalArguments == null) {
            throw new NullPointerException("alertOptionalArguments is marked non-null but is null");
        }
        return this.send(false, token, text, to, alertOptionalArguments);
    }

    public SingleMessageResponse simulateSendAlert(String token, String text, String to, @NonNull AlertOptionalArguments alertOptionalArguments) throws IOException {
        if (alertOptionalArguments == null) {
            throw new NullPointerException("alertOptionalArguments is marked non-null but is null");
        }
        return this.send(true, token, text, to, alertOptionalArguments);
    }

    public SingleMessageResponse sendMarketing(String token, String text, String to) throws IOException {
        return this.send(false, token, text, to, MarketingOptionalArguments.builder().sender(NoSender.build()).build());
    }

    public SingleMessageResponse simulateSendMarketing(String token, String text, String to) throws IOException {
        return this.send(true, token, text, to, MarketingOptionalArguments.builder().sender(NoSender.build()).build());
    }

    public SingleMessageResponse sendMarketing(String token, String text, String to, @NonNull MarketingOptionalArguments marketingOptionalArguments) throws IOException {
        if (marketingOptionalArguments == null) {
            throw new NullPointerException("marketingOptionalArguments is marked non-null but is null");
        }
        return this.send(false, token, text, to, marketingOptionalArguments);
    }

    public SingleMessageResponse simulateSendMarketing(String token, String text, String to, @NonNull MarketingOptionalArguments marketingOptionalArguments) throws IOException {
        if (marketingOptionalArguments == null) {
            throw new NullPointerException("marketingOptionalArguments is marked non-null but is null");
        }
        return this.send(true, token, text, to, marketingOptionalArguments);
    }

    private SingleMessageResponse send(boolean simulate, @NonNull String token, @NonNull String text, @NonNull String to, @NonNull OptionalArguments optionalArguments) throws IOException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        if (optionalArguments == null) {
            throw new NullPointerException("optionalArguments is marked non-null but is null");
        }
        E164Helper.check(to);
        ImmutablePair<Integer, String> response = this.get(this.buildSendUrl(simulate, text, to, optionalArguments), token);
        String body = (String)response.getRight();
        SingleMessageResultResponse responseObject = GsonHelper.fromJson(body, SingleMessageResultResponse.class);
        return SingleMessageResponse.builder().uid(UUID.randomUUID().toString()).statusCode((Integer)response.getLeft()).effectiveResponse(responseObject).build();
    }

    private String buildSendUrl(boolean simulate, @NonNull String text, @NonNull String to, @NonNull OptionalArguments optionalArguments) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        if (optionalArguments == null) {
            throw new NullPointerException("optionalArguments is marked non-null but is null");
        }
        boolean textEmpty = StringUtils.isEmpty((CharSequence)text);
        boolean toEmpty = StringUtils.isEmpty((CharSequence)to);
        RequiredParameterException.RequiredParameterExceptionBuilder exception = RequiredParameterException.builder();
        if (textEmpty) {
            exception.requiredParam("text", text);
        }
        if (toEmpty) {
            exception.requiredParam(TO, to);
        }
        if (textEmpty || toEmpty) {
            throw exception.build();
        }
        Object url = URL + (simulate ? SIMULATE_URL : "");
        boolean hasAtLeastOneArgument = optionalArguments.hasAtLeastOneArgument();
        url = String.format("%s?%s=%s&%s=%s", url, "text", SMSUpURLEncoder.encode(text), TO, SMSUpURLEncoder.encode(to));
        if (hasAtLeastOneArgument) {
            url = (String)url + optionalArguments.toUrl();
        }
        return url;
    }
}

