/*
 * Decompiled with CFR 0.152.
 */
package io.nats.vertx;

import io.nats.client.Connection;
import io.nats.client.ErrorListener;
import io.nats.client.Options;
import io.nats.client.impl.ErrorListenerLoggerImpl;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;

public class NatsOptions {
    private Options.Builder natsBuilder;
    private Vertx vertx;
    private boolean periodicFlush;
    private long periodicFlushInterval;
    private boolean autoReconnect = false;
    private Handler<Throwable> exceptionHandler;

    public Handler<Throwable> getExceptionHandler() {
        return this.exceptionHandler;
    }

    public NatsOptions setExceptionHandler(Handler<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public NatsOptions setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
        return this;
    }

    public Options.Builder getNatsBuilder() {
        if (this.natsBuilder == null) {
            this.natsBuilder = new Options.Builder();
            if (!this.isAutoReconnect()) {
                this.natsBuilder.noReconnect();
            }
        }
        this.configureExceptionHandler();
        return this.natsBuilder;
    }

    private void configureExceptionHandler() {
        if (this.getExceptionHandler() != null) {
            final Handler<Throwable> exceptionHandler = this.getExceptionHandler();
            if (!(this.natsBuilder.build().getErrorListener() instanceof ErrorListenerLoggerImpl)) {
                this.natsBuilder.errorListener(new ErrorListener(){

                    public void errorOccurred(Connection conn, String error) {
                        exceptionHandler.handle((Object)new IllegalStateException(error));
                    }

                    public void exceptionOccurred(Connection conn, Exception exp) {
                        exceptionHandler.handle((Object)new IllegalStateException(exp));
                    }
                });
            } else {
                final ErrorListener errorListener = this.natsBuilder.build().getErrorListener();
                this.natsBuilder.errorListener(new ErrorListener(){

                    public void errorOccurred(Connection conn, String error) {
                        errorListener.errorOccurred(conn, error);
                        exceptionHandler.handle((Object)new IllegalStateException(error));
                    }

                    public void exceptionOccurred(Connection conn, Exception exp) {
                        errorListener.exceptionOccurred(conn, exp);
                        exceptionHandler.handle((Object)new IllegalStateException(exp));
                    }
                });
            }
        }
    }

    public NatsOptions setNatsBuilder(Options.Builder natsBuilder) {
        this.natsBuilder = natsBuilder;
        return this;
    }

    public Vertx getVertx() {
        if (this.vertx == null) {
            this.vertx = Vertx.vertx();
        }
        return this.vertx;
    }

    public NatsOptions setVertx(Vertx vertx) {
        this.vertx = vertx;
        return this;
    }

    public boolean isPeriodicFlush() {
        return this.periodicFlush;
    }

    public NatsOptions setPeriodicFlush(boolean periodicFlush) {
        this.periodicFlush = periodicFlush;
        return this;
    }

    public long getPeriodicFlushInterval() {
        return this.periodicFlushInterval;
    }

    public NatsOptions setPeriodicFlushInterval(long periodicFlushInterval) {
        this.periodicFlushInterval = periodicFlushInterval;
        return this;
    }
}

