/*
 * Decompiled with CFR 0.152.
 */
package io.nats.vertx;

import io.nats.client.Connection;
import io.nats.client.Message;
import io.nats.client.Subscription;
import io.nats.client.impl.AckType;
import io.nats.client.impl.Headers;
import io.nats.client.impl.NatsJetStreamMetaData;
import io.nats.client.support.Status;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import java.time.Duration;
import java.util.concurrent.TimeoutException;

public interface NatsVertxMessage
extends Message {
    public Message message();

    public Vertx vertx();

    default public ContextInternal context() {
        return (ContextInternal)this.vertx().getOrCreateContext();
    }

    default public Future<Void> ackAsync() {
        Promise promise = Promise.promise();
        this.context().executeBlocking(event -> {
            try {
                this.message().ack();
                promise.complete();
            }
            catch (Throwable e) {
                promise.tryFail(e);
            }
        }, false);
        return promise.future();
    }

    default public Future<Void> nakAsync() {
        Promise promise = Promise.promise();
        this.context().executeBlocking(event -> {
            try {
                this.message().nak();
                promise.complete();
            }
            catch (Throwable e) {
                promise.tryFail(e);
            }
        }, false);
        return promise.future();
    }

    default public Future<Void> nakWithDelayAsync(Duration nakDelay) {
        Promise promise = Promise.promise();
        this.context().executeBlocking(event -> {
            try {
                this.message().nakWithDelay(nakDelay);
                promise.complete();
            }
            catch (Throwable e) {
                promise.tryFail(e);
            }
        }, false);
        return promise.future();
    }

    default public Future<Void> ackWithDelayAsync(Duration ackDelay) {
        Promise promise = Promise.promise();
        this.context().executeBlocking(event -> {
            try {
                this.message().ackSync(ackDelay);
                promise.complete();
            }
            catch (Throwable e) {
                promise.tryFail(e);
            }
        }, false);
        return promise.future();
    }

    default public Future<Void> nakWithDelayAsync(long nakDelayMillis) {
        return this.nakWithDelayAsync(Duration.ofMillis(nakDelayMillis));
    }

    default public Future<Void> ackWithDelayAsync(long nakDelayMillis) {
        return this.ackWithDelayAsync(Duration.ofMillis(nakDelayMillis));
    }

    default public String getSubject() {
        return this.message().getSubject();
    }

    default public String getReplyTo() {
        return this.message().getReplyTo();
    }

    default public boolean hasHeaders() {
        return this.message().hasHeaders();
    }

    default public Headers getHeaders() {
        return this.message().getHeaders();
    }

    default public boolean isStatusMessage() {
        return this.message().isStatusMessage();
    }

    default public Status getStatus() {
        return this.message().getStatus();
    }

    default public byte[] getData() {
        return this.message().getData();
    }

    default public boolean isUtf8mode() {
        return this.message().isUtf8mode();
    }

    default public Subscription getSubscription() {
        return this.message().getSubscription();
    }

    default public String getSID() {
        return this.message().getSID();
    }

    default public Connection getConnection() {
        return this.message().getConnection();
    }

    default public NatsJetStreamMetaData metaData() {
        return this.message().metaData();
    }

    default public AckType lastAck() {
        return this.message().lastAck();
    }

    default public void ack() {
        this.message().ack();
    }

    default public void ackSync(Duration timeout) throws TimeoutException, InterruptedException {
        this.message().ackSync(timeout);
    }

    default public void nak() {
        this.message().nak();
    }

    default public void nakWithDelay(Duration nakDelay) {
        this.message().nakWithDelay(nakDelay);
    }

    default public void nakWithDelay(long nakDelayMillis) {
        this.message().nakWithDelay(nakDelayMillis);
    }

    default public void term() {
        this.message().term();
    }

    default public void inProgress() {
        this.message().term();
    }

    default public boolean isJetStream() {
        return this.message().isJetStream();
    }
}

