/*
 * Decompiled with CFR 0.152.
 */
package io.nats.vertx.impl;

import io.nats.client.Connection;
import io.nats.client.ConnectionListener;
import io.nats.client.JetStream;
import io.nats.client.JetStreamOptions;
import io.nats.client.Message;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.client.Subscription;
import io.nats.vertx.NatsClient;
import io.nats.vertx.NatsOptions;
import io.nats.vertx.NatsStream;
import io.nats.vertx.impl.NatsStreamImpl;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.streams.WriteStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class NatsClientImpl
implements NatsClient {
    private static final Duration noWait = Duration.ofNanos(1L);
    private final Vertx vertx;
    private final boolean periodicFlush;
    private AtomicReference<Connection> connection = new AtomicReference();
    private final Options options;
    private Promise<Void> connectFuture;
    private AtomicReference<Handler<Throwable>> exceptionHandler = new AtomicReference<Handler>(Throwable::printStackTrace);
    private final long periodicFlushInterval;
    private final ConcurrentHashMap<String, Subscription> subscriptionMap = new ConcurrentHashMap();

    public NatsClientImpl(Options.Builder config, NatsOptions natsOptions) {
        this.vertx = natsOptions.getVertx();
        this.periodicFlush = natsOptions.isPeriodicFlush();
        this.periodicFlushInterval = natsOptions.getPeriodicFlushInterval();
        this.options = this.wireConnectListener(config, this.context());
        if (natsOptions.getExceptionHandler() != null) {
            this.exceptionHandler.set(natsOptions.getExceptionHandler());
        }
    }

    private ContextInternal context() {
        return (ContextInternal)this.vertx.getOrCreateContext();
    }

    private Options wireConnectListener(Options.Builder config, ContextInternal context) {
        Options build = config.build();
        PromiseInternal promise = context.promise();
        if (build.getConnectionListener() == null) {
            config.connectionListener((arg_0, arg_1) -> NatsClientImpl.lambda$wireConnectListener$0((Promise)promise, arg_0, arg_1));
        } else {
            ConnectionListener connectionListener = build.getConnectionListener();
            config.connectionListener((arg_0, arg_1) -> NatsClientImpl.lambda$wireConnectListener$1((Promise)promise, connectionListener, arg_0, arg_1));
        }
        this.connectFuture = promise;
        return config.build();
    }

    @Override
    public Future<Void> connect() {
        this.context().executeBlocking(event -> {
            try {
                this.connection.set(Nats.connect((Options)this.options));
            }
            catch (Exception e) {
                this.handleException(this.connectFuture, e);
            }
        }, false);
        if (this.periodicFlush) {
            this.context().setTimer(this.periodicFlushInterval, event -> this.runFlush());
        }
        return this.connectFuture.future();
    }

    private void runFlush() {
        if (this.periodicFlush) {
            this.context().executeBlocking(event -> {
                try {
                    Connection conn = this.connection.get();
                    if (conn != null && conn.getStatus() == Connection.Status.CONNECTED) {
                        conn.flush(Duration.ofSeconds(1L));
                    }
                    this.context().setTimer(this.periodicFlushInterval, timerEvent -> this.runFlush());
                }
                catch (Exception e) {
                    this.exceptionHandler.get().handle((Object)e);
                }
            });
        }
    }

    @Override
    public Future<NatsStream> jetStream() {
        PromiseInternal promise = this.context().promise();
        this.context().executeBlocking(arg_0 -> this.lambda$jetStream$6((Promise)promise, arg_0), false);
        return promise.future();
    }

    @Override
    public Future<NatsStream> jetStream(JetStreamOptions options) {
        PromiseInternal promise = this.context().promise();
        this.context().executeBlocking(arg_0 -> this.lambda$jetStream$7(options, (Promise)promise, arg_0), false);
        return promise.future();
    }

    public WriteStream<Message> exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler.set(handler);
        return this;
    }

    public Future<Void> write(Message data) {
        PromiseInternal promise = this.context().promise();
        this.context().executeBlocking(arg_0 -> this.lambda$write$8(data, (Promise)promise, arg_0), false);
        return promise.future();
    }

    public void write(Message data, Handler<AsyncResult<Void>> handler) {
        PromiseInternal promise = this.context().promise();
        this.context().executeBlocking(arg_0 -> this.lambda$write$9(data, (Promise)promise, handler, arg_0), false);
    }

    public void end(Handler<AsyncResult<Void>> handler) {
        PromiseInternal promise = this.context().promise();
        this.context().executeBlocking(arg_0 -> this.lambda$end$10((Promise)promise, handler, arg_0), false);
    }

    public WriteStream<Message> setWriteQueueMaxSize(int maxSize) {
        return this;
    }

    public boolean writeQueueFull() {
        return false;
    }

    @Override
    public NatsClient drainHandler(Handler<Void> handler) {
        return this;
    }

    @Override
    public void publish(Message data, Handler<AsyncResult<Void>> handler) {
        this.write(data, handler);
    }

    @Override
    public Future<Void> publish(Message data) {
        return this.write(data);
    }

    @Override
    public Future<Void> publish(String subject, String replyTo, String message) {
        return this.publish(subject, replyTo, message.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public Future<Void> publish(String subject, String replyTo, byte[] message) {
        PromiseInternal promise = this.context().promise();
        this.context().executeBlocking(arg_0 -> this.lambda$publish$11(subject, replyTo, message, (Promise)promise, arg_0), false);
        return promise.future();
    }

    @Override
    public Future<Void> publish(String subject, String message) {
        return this.publish(subject, message.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public Future<Void> publish(String subject, byte[] message) {
        PromiseInternal promise = this.context().promise();
        this.context().executeBlocking(arg_0 -> this.lambda$publish$12(subject, message, (Promise)promise, arg_0), false);
        return promise.future();
    }

    private void handleException(Promise<?> promise, Exception e) {
        promise.fail((Throwable)e);
        this.exceptionHandler.get().handle((Object)e);
    }

    private void handleExceptionWithHandler(Handler<AsyncResult<Void>> handler, Promise<Void> promise, Exception e) {
        promise.fail((Throwable)e);
        handler.handle((Object)promise.future());
        this.exceptionHandler.get().handle((Object)e);
    }

    @Override
    public void request(Message data, Handler<AsyncResult<Message>> handler) {
        PromiseInternal promise = this.context().promise();
        this.context().executeBlocking(arg_0 -> this.lambda$request$13(data, (Promise)promise, handler, arg_0), false);
    }

    @Override
    public Future<Message> request(Message data) {
        return this.context().executeBlocking(event -> {
            try {
                CompletableFuture request = this.connection.get().request(data);
                Message message = (Message)request.get();
                event.complete((Object)message);
            }
            catch (Exception e) {
                this.handleException((Promise<?>)event, e);
            }
        }, false);
    }

    @Override
    public Future<Message> request(String subject, String message) {
        return this.request(subject, message.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public Future<Message> request(String subject, byte[] message) {
        return this.context().executeBlocking(event -> {
            try {
                CompletableFuture request = this.connection.get().request(subject, message);
                Message result = (Message)request.get();
                event.complete((Object)result);
            }
            catch (Exception e) {
                this.handleException((Promise<?>)event, e);
            }
        }, false);
    }

    @Override
    public void request(Message data, Handler<AsyncResult<Message>> handler, Duration timeout) {
        PromiseInternal promise = this.context().promise();
        this.context().executeBlocking(arg_0 -> this.lambda$request$16(data, timeout, (Promise)promise, handler, arg_0), false);
    }

    @Override
    public Future<Message> request(Message data, Duration timeout) {
        return this.context().executeBlocking(event -> {
            try {
                CompletableFuture request = this.connection.get().request(data);
                Message message = (Message)request.get(timeout.toNanos(), TimeUnit.NANOSECONDS);
                event.complete((Object)message);
            }
            catch (Exception e) {
                this.handleException((Promise<?>)event, e);
            }
        }, false);
    }

    @Override
    public Future<Message> request(String subject, String message, Duration timeout) {
        return this.request(subject, message.getBytes(StandardCharsets.UTF_8), timeout);
    }

    @Override
    public Future<Message> request(String subject, byte[] message, Duration timeout) {
        return this.context().executeBlocking(event -> {
            try {
                CompletableFuture request = this.connection.get().request(subject, message);
                Message result = (Message)request.get(timeout.toNanos(), TimeUnit.NANOSECONDS);
                event.complete((Object)result);
            }
            catch (Exception e) {
                this.handleException((Promise<?>)event, e);
            }
        }, false);
    }

    @Override
    public Future<Void> subscribe(String subject, Handler<Message> handler) {
        PromiseInternal promise = this.context().promise();
        this.context().executeBlocking(arg_0 -> this.lambda$subscribe$20(subject, handler, (Promise)promise, arg_0), false);
        return promise.future();
    }

    private void drainSubscription(Handler<Message> handler, Subscription subscribe, String subject) {
        try {
            Message message = subscribe.nextMessage(noWait);
            int count = 0;
            while (message != null) {
                ++count;
                try {
                    handler.handle((Object)message);
                }
                catch (Exception e) {
                    this.exceptionHandler.get().handle((Object)e);
                }
                message = subscribe.nextMessage(noWait);
            }
            if (this.subscriptionMap.containsKey(subject)) {
                this.context().setTimer(100L, event -> this.context().executeBlocking(e -> this.drainSubscription(handler, subscribe, subject), false));
            }
        }
        catch (Exception e) {
            this.exceptionHandler.get().handle((Object)e);
        }
    }

    @Override
    public Future<Void> subscribe(String subject, String queue, Handler<Message> handler) {
        PromiseInternal promise = this.context().promise();
        this.context().executeBlocking(arg_0 -> this.lambda$subscribe$24(subject, queue, handler, (Promise)promise, arg_0), false);
        return promise.future();
    }

    @Override
    public Future<Void> unsubscribe(String subject) {
        PromiseInternal promise = this.context().promise();
        this.context().executeBlocking(arg_0 -> this.lambda$unsubscribe$25(subject, (Promise)promise, arg_0), false);
        return promise.future();
    }

    @Override
    public Connection getConnection() {
        return this.connection.get();
    }

    private /* synthetic */ void lambda$unsubscribe$25(String subject, Promise promise, Promise event) {
        try {
            Subscription subscription = this.subscriptionMap.get(subject);
            if (subscription != null) {
                this.subscriptionMap.remove(subject);
                subscription.unsubscribe();
            }
            promise.complete();
        }
        catch (Exception e) {
            this.handleException(promise, e);
        }
    }

    private /* synthetic */ void lambda$subscribe$24(String subject, String queue, Handler handler, Promise promise, Promise event) {
        try {
            Subscription subscribe = this.connection.get().subscribe(subject, queue);
            this.subscriptionMap.put(subject, subscribe);
            this.context().executeBlocking(event1 -> this.drainSubscription((Handler<Message>)handler, subscribe, subject), false);
            promise.complete();
        }
        catch (Exception e) {
            this.handleException(promise, e);
        }
    }

    private /* synthetic */ void lambda$subscribe$20(String subject, Handler handler, Promise promise, Promise event) {
        try {
            Subscription subscribe = this.connection.get().subscribe(subject);
            this.subscriptionMap.put(subject, subscribe);
            this.context().executeBlocking(event1 -> this.drainSubscription((Handler<Message>)handler, subscribe, subject));
            promise.complete();
        }
        catch (Exception e) {
            this.handleException(promise, e);
        }
    }

    private /* synthetic */ void lambda$request$16(Message data, Duration timeout, Promise promise, Handler handler, Promise event) {
        try {
            CompletableFuture request = this.connection.get().request(data);
            Message message = (Message)request.get(timeout.toNanos(), TimeUnit.NANOSECONDS);
            promise.complete((Object)message);
            handler.handle((Object)promise.future());
        }
        catch (Exception e) {
            promise.fail((Throwable)e);
            handler.handle((Object)promise.future());
            this.exceptionHandler.get().handle((Object)e);
        }
    }

    private /* synthetic */ void lambda$request$13(Message data, Promise promise, Handler handler, Promise event) {
        try {
            CompletableFuture request = this.connection.get().request(data);
            Message message = (Message)request.get();
            promise.complete((Object)message);
            handler.handle((Object)promise.future());
        }
        catch (Exception e) {
            promise.fail((Throwable)e);
            handler.handle((Object)promise.future());
            this.exceptionHandler.get().handle((Object)e);
        }
    }

    private /* synthetic */ void lambda$publish$12(String subject, byte[] message, Promise promise, Promise event) {
        try {
            this.connection.get().publish(subject, message);
            promise.complete();
        }
        catch (Exception e) {
            this.handleException(promise, e);
        }
    }

    private /* synthetic */ void lambda$publish$11(String subject, String replyTo, byte[] message, Promise promise, Promise event) {
        try {
            this.connection.get().publish(subject, replyTo, message);
            promise.complete();
        }
        catch (Exception e) {
            this.handleException(promise, e);
        }
    }

    private /* synthetic */ void lambda$end$10(Promise promise, Handler handler, Promise event) {
        try {
            this.connection.get().close();
            promise.complete();
            handler.handle((Object)promise.future());
        }
        catch (Exception e) {
            this.handleExceptionWithHandler((Handler<AsyncResult<Void>>)handler, (Promise<Void>)promise, e);
        }
    }

    private /* synthetic */ void lambda$write$9(Message data, Promise promise, Handler handler, Promise event) {
        try {
            this.connection.get().publish(data);
            promise.complete();
            handler.handle((Object)promise.future());
        }
        catch (Exception e) {
            this.handleExceptionWithHandler((Handler<AsyncResult<Void>>)handler, (Promise<Void>)promise, e);
        }
    }

    private /* synthetic */ void lambda$write$8(Message data, Promise promise, Promise event) {
        try {
            this.connection.get().publish(data);
            promise.complete();
        }
        catch (Exception e) {
            this.handleException(promise, e);
        }
    }

    private /* synthetic */ void lambda$jetStream$7(JetStreamOptions options, Promise promise, Promise event) {
        try {
            JetStream jetStream = this.connection.get().jetStream(options);
            promise.complete((Object)new NatsStreamImpl(jetStream, this.connection.get(), this.vertx, this.exceptionHandler.get()));
        }
        catch (Exception e) {
            this.handleException(promise, e);
        }
    }

    private /* synthetic */ void lambda$jetStream$6(Promise promise, Promise event) {
        try {
            JetStream jetStream = this.connection.get().jetStream();
            promise.complete((Object)new NatsStreamImpl(jetStream, this.connection.get(), this.vertx, this.exceptionHandler.get()));
        }
        catch (Exception e) {
            this.handleException(promise, e);
        }
    }

    private static /* synthetic */ void lambda$wireConnectListener$1(Promise promise, ConnectionListener connectionListener, Connection conn, ConnectionListener.Events type) {
        if (type == ConnectionListener.Events.CONNECTED) {
            promise.complete();
        }
        connectionListener.connectionEvent(conn, type);
    }

    private static /* synthetic */ void lambda$wireConnectListener$0(Promise promise, Connection conn, ConnectionListener.Events type) {
        if (type == ConnectionListener.Events.CONNECTED) {
            promise.complete();
        }
    }
}

