package io.nearpay.install.core.data.dto

import android.content.Context
import android.content.pm.PackageManager

enum class DataEnvironments(
    val id: Int,
    val serverUrl: String,
    val pluginPackageName: String
) {
    STAGING(
        1,
        "https://staging-api.nearpay.io/",
        "io.nearpay.nearpay"
    ),
    SANDBOX(
        2,
        "https://sandbox-api.nearpay.io/",
        "io.nearpay.nearpay.sandbox"
    ),
    SANDBOX_V2(
        3,
        "https://sandbox-api.nearpay.io/",
        "io.nearpay.readerplugin"
    ),
    TESTING(
        3,
        "https://testing-api.nearpay.io/",
        "io.nearpay.nearpay.testing"
    ),
    PRODUCTION(
        4,
        "https://api.nearpay.io/",
        "io.nearpay.nearpay"
    )
}

fun DataEnvironments.backwardSupportPluginPackageName(context: Context): String = when (this) {
    DataEnvironments.PRODUCTION, DataEnvironments.STAGING -> {
        try {
            context.packageManager.getPackageInfo(pluginPackageName, 0)
            pluginPackageName
        } catch (e: PackageManager.NameNotFoundException) {
            "io.nearpay.softpos"
        }
    }

    DataEnvironments.SANDBOX, DataEnvironments.SANDBOX_V2, DataEnvironments.TESTING -> {
        pluginPackageName
    }
}