package io.nearpay.install.core.data.dto

sealed class InstallationFailure {
    data class InstallFailed(val error: String) : InstallationFailure()
    data class NetworkError(val message: String) : InstallationFailure()
    object AlreadyInstalled : InstallationFailure()
    object UnsupportedSdkVersion : InstallationFailure()
    object DownloadedFileNotFound : InstallationFailure()
}