package io.nearpay.install.core.data.dto

enum class NiceErrors(
    val messageError: ServerErrorMessage
) {
    SDK_ALREADY_INSTALLED(
        ServerErrorMessage(
            code_text = "sdk_already_installed",
            code = 5014,
            error = LocalizationField(
                arabic = "البرنامج المساعد للدفع مثبت بالفعل",
                english = "Payment plugin is already installed "
            ),
            solution = LocalizationField(
                arabic = "يرجى إلغاء التثبيت والتثبيت مرة أخرى.",
                english = "Please uninstall and install again. "
            ),
            level = MessageErrorLevel.LOW,
            source = MessageErrorSource(
                arabic = "الجهاز",
                english = "Device",
                color = "#000000"
            )
        )
    ),

    SDK_DOWNLOAD_FILE_NOT_FOUND(
        ServerErrorMessage(
            code_text = "sdk_download_file_not_found",
            code = 5015,
            error = LocalizationField(
                arabic = "تم تنزيل البرنامج المساعد للدفع ولكن لم يتم العثور عليه",
                english = "payment plugin downloaded but not found"
            ),
            solution = LocalizationField(
                arabic = "لمزيد من المعلومات، يمكنك التواصل مع فريق الدعم الخاص بمزود الخدمة",
                english = "Contact your technical provider"
            ),
            level = MessageErrorLevel.MEDIUM,
            source = MessageErrorSource(
                arabic = "الجهاز",
                english = "Device",
                color = "#000000"
            )
        )
    ),

    SDK_INSTALL_FAILED(
        ServerErrorMessage(
            code_text = "sdk_install_failed",
            code = 5016,
            error = LocalizationField(
                arabic = "فشل تثبيت البرنامج المساعد للدفع",
                english = "payment plugin install failed"
            ),
            solution = LocalizationField(
                arabic = "يرجى المحاولة مرة اخرى",
                english = "Please try again"
            ),
            level = MessageErrorLevel.HIGH,
            source = MessageErrorSource(
                arabic = "الجهاز",
                english = "Device",
                color = "#000000"
            )
        )
    ),

    SDK_UNSUPPORTED_ANDROID_SDK_VERSION(
        ServerErrorMessage(
            code_text = "sdk_unsupported_android_sdk_version",
            code = 5017,
            error = LocalizationField(
                arabic = "إصدار sdk غير مدعوم",
                english = "unsupported sdk version"
            ),
            solution = LocalizationField(
                arabic = "يرجى تحديث SDK الخاص بك",
                english = "Please update your SDK "
            ),
            level = MessageErrorLevel.HIGH,
            source = MessageErrorSource(
                arabic = "الجهاز",
                english = "Device",
                color = "#000000"
            )
        )
    ),

    SDK_DOWNLOAD_FAILED(
        ServerErrorMessage(
            code_text = "sdk_download_failed",
            code = 5018,
            error = LocalizationField(
                arabic = "فشل تحميل البرنامج المساعد للدفع",
                english = "payment plugin failed to download"
            ),
            solution = LocalizationField(
                arabic = "",
                english = "Please try to download again "
            ),
            level = MessageErrorLevel.HIGH,
            source = MessageErrorSource(
                arabic = "NearPay",
                english = "NearPay",
                color = "#000000"
            )
        )
    ),
    PARSING_RESPONSE_FAILED(
        ServerErrorMessage(
            code_text = "parsing_response_failed",
            code = 5001,
            error = LocalizationField("حدث خطأ غير متوقع", "Unexpected Error"),
            solution = LocalizationField(
                "لمزيد من المعلومات، يمكنك التواصل مع فريق الدعم الخاص بمزود الخدمة",
                "Contact your technical provider"
            ),
            level = MessageErrorLevel.HIGH,
            source = MessageErrorSource(
                arabic = "NearPay",
                english = "NearPay",
                color = "#000000"
            )
        )
    ),
    NETWORK_ERROR(
        ServerErrorMessage(
            code_text = "network_error",
            code = 5002,
            error = LocalizationField("حدث خطأ في الشبكة", "A network error has occurred"),
            solution = LocalizationField(
                "تحقق من الاتصال بشبكة Wi-Fi أو 4G/5G ",
                "Check your Wi-Fi or 4G/5G connection"
            ),
            level = MessageErrorLevel.LOW,
            source = MessageErrorSource(
                arabic = "الجهاز",
                english = "Device",
                color = "#000000"
            )
        )
    ),

    UNEXPECTED_ERROR(
        ServerErrorMessage(
            code_text = "unexpected_error",
            code = 5003,
            error = LocalizationField("حدث خطأ غير متوقع", "Unexpected Error"),
            solution = LocalizationField(
                "لمزيد من المعلومات، يمكنك التواصل مع فريق الدعم الخاص بمزود التقنية",
                "Contact your technical provider"
            ),
            level = MessageErrorLevel.HIGH,
            source = MessageErrorSource(
                arabic = "NearPay",
                english = "NearPay",
                color = "#000000"
            )
        )
    ),

    PARSING_ERROR_MSG_FAILED(
        ServerErrorMessage(
            code_text = "parsing_error_msg_failed",
            code = 5000,
            error = LocalizationField("حدث خطأ غير متوقع", "Unexpected Error"),
            solution = LocalizationField(
                "لمزيد من المعلومات، يمكنك التواصل مع فريق الدعم الخاص بمزود الخدمة",
                "Contact your technical provider"
            ),
            level = MessageErrorLevel.HIGH,
            source = MessageErrorSource(
                arabic = "NearPay",
                english = "NearPay",
                color = "#000000"
            )
        )
    ),

    SDK_MARKETPLACE_STORE_FAILED(
    ServerErrorMessage(
    code_text = "sdk_marketplace_store_failed",
    code = 5019,
    error = LocalizationField(
    arabic = "لم نستطع إيجاد التطبيق على متجر التطبيقات",
    english = "Could Not Find Application on System's Apps Marketplace Store"
    ),
    solution = LocalizationField(
    arabic = "يرجى المحاولة مرة اخرى",
    english = "Please try again"
    ),
    level = MessageErrorLevel.HIGH,
    source = MessageErrorSource(
    arabic = "الجهاز",
    english = "Device",
    color = "#000000"
    )
    )
    )
}