package io.nearpay.install.core.data.dto

class UIConfiguration(
    val horizontalUi: HorizontalUI,
    val verticalUi: VerticalUI,
    val paymentTextAr: String,
    val paymentTextEn: String
) {

    companion object {
        fun getHorizontalUI(uiPosition: UIPosition): HorizontalUI {
            return when (uiPosition) {
                UIPosition.CENTER_END,
                UIPosition.TOP_END,
                UIPosition.BOTTOM_END -> HorizontalUI.END

                UIPosition.CENTER_START,
                UIPosition.TOP_START,
                UIPosition.BOTTOM_START -> HorizontalUI.START

                UIPosition.CENTER_RIGHT,
                UIPosition.TOP_RIGHT,
                UIPosition.BOTTOM_RIGHT -> HorizontalUI.RIGHT

                UIPosition.CENTER_LEFT,
                UIPosition.TOP_LEFT,
                UIPosition.BOTTOM_LEFT -> HorizontalUI.LEFT

                UIPosition.DEFAULT -> HorizontalUI.DEFAULT

                UIPosition.CENTER,
                UIPosition.CENTER_TOP,
                UIPosition.CENTER_BOTTOM -> HorizontalUI.CENTER
            }
        }

        fun getVerticalUI(uiPosition: UIPosition): VerticalUI {
            return when (uiPosition) {
                UIPosition.CENTER_TOP,
                UIPosition.TOP_END,
                UIPosition.TOP_START,
                UIPosition.TOP_RIGHT,
                UIPosition.TOP_LEFT -> VerticalUI.TOP

                UIPosition.CENTER_BOTTOM,
                UIPosition.BOTTOM_END,
                UIPosition.BOTTOM_START,
                UIPosition.BOTTOM_RIGHT,
                UIPosition.BOTTOM_LEFT -> VerticalUI.BOTTOM

                UIPosition.DEFAULT -> VerticalUI.DEFAULT

                UIPosition.CENTER,
                UIPosition.CENTER_LEFT,
                UIPosition.CENTER_START,
                UIPosition.CENTER_RIGHT,
                UIPosition.CENTER_END -> VerticalUI.CENTER
            }
        }
    }
}