package io.nearpay.install.core.data.remote

suspend inline fun <T : Any> safeApiCall(
    crossinline call: suspend () -> T
): ApiResponse<T> {

    return try {
        val response = call()
        ApiResponse.Success(response)
    } catch (throwable: Throwable) {
        resolveError(throwable)
    }
}