package io.nearpay.install.core.utils

import io.nearpay.install.core.data.dto.ServerErrorMessage


 sealed class InstallState {
    object Ideal : InstallState()
    data class Start(val startInstallationAction: () -> Unit, val version: String = "") :
        InstallState()

    data class Downloading(val progress: Int) : InstallState()
    object Installing : InstallState()
    object Completed : InstallState()
    data class Failed(val serverErrorMessage: ServerErrorMessage) : InstallState()
}