package io.nearpay.install.core.utils

import android.os.Bundle
import androidx.annotation.IdRes
import androidx.fragment.app.Fragment
import androidx.navigation.NavController
import androidx.navigation.NavDirections
import androidx.navigation.NavGraph

fun NavController.navigateSafely(direction: NavDirections, fragment: Fragment? = null) {
    val currentDestination = currentDestination
    currentDestination?.let {
        val navAction = currentDestination.getAction(direction.actionId)
        navAction?.let {
            val destinationId: Int = navAction.destinationId.orZero()
            val currentNode = if (currentDestination is NavGraph) currentDestination else currentDestination.parent
            if (destinationId != 0 && currentNode != null && currentNode.findNode(destinationId) != null) {
                fragment?.also {
                    if (it.isAdded) navigate(direction)
                } ?: run {
                    navigate(direction)
                }
            }
        }
    }
}

fun NavController.navigateSafely(@IdRes resId: Int, bundle: Bundle? = null) {
    val currentDestination = currentDestination
    currentDestination?.let {
        val navAction = currentDestination.getAction(resId)
        navAction?.let {
            val destinationId = navAction.destinationId.orZero()
            val currentNode = if (currentDestination is NavGraph) currentDestination else currentDestination.parent
            if (destinationId != 0 && currentNode != null && currentNode.findNode(destinationId) != null) {
                bundle?.also {
                    navigate(resId, bundle)
                } ?: run { navigate(resId) }
            }
        }
    }
}

fun NavController.navigateUpSafely(fragment: Fragment) {
    if (fragment.isAdded) {
        navigateUp()
    }
}

fun NavController.popBackStackSafely(fragment: Fragment) {
    if (fragment.isAdded) {
        popBackStack()
    }
}

fun Int?.orZero(): Int {
    return this ?: 0
}