package io.nearpay.install.core.utils

import android.view.View

abstract class OnSingleClickListener : View.OnClickListener {
    private var enabled = true

    override fun onClick(v: View) {
        if (enabled) {
            enabled = false
            onOneClick(v)
        } else {
        }
    }

    abstract fun onOneClick(v: View)
}

fun View.setOnSingleClickListener(doClick: (View) -> Unit) {
    setOnClickListener(object : OnSingleClickListener() {
        override fun onOneClick(v: View) {
            doClick(v)
        }
    })
}