package io.nearpay.install.core.utils

import android.content.Context
import android.view.View
import android.widget.TextView
import androidx.core.content.ContextCompat

// width of wide screens in DP
const val WIDE_SCREENS: Float = 600F

fun Context.getWidthDp() = resources.displayMetrics.run { widthPixels / density }

fun TextView.textColor(context: Context, color:Int){
    setTextColor(ContextCompat.getColor(context,color))
}

fun TextView.setTextOrHide(text: String?) {
    if (text.isNullOrBlank()) {
        visibility = View.GONE
    } else {
        visibility = View.VISIBLE
        setText(text)
    }
}