package io.nearpay.install.ui

import android.content.Intent
import android.net.Uri
import android.os.Build
import android.os.Bundle
import android.provider.Settings
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.annotation.RequiresApi
import androidx.fragment.app.Fragment
import androidx.lifecycle.lifecycleScope
import androidx.navigation.fragment.findNavController
import io.nearpay.install.R
import io.nearpay.install.core.databinding.FragmentInstallRequestPermissionBinding
import io.nearpay.install.core.utils.navigateSafely
import kotlinx.coroutines.delay
import kotlinx.coroutines.ensureActive
import kotlinx.coroutines.isActive
import kotlinx.coroutines.launch

internal class InstallPluginPermissionFragment : Fragment(R.layout.fragment_install_request_permission) {

    private var _binding: FragmentInstallRequestPermissionBinding? = null
    private val binding get() = _binding!!

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        _binding = FragmentInstallRequestPermissionBinding.inflate(inflater, container, false)
        return binding.root
    }

    @RequiresApi(Build.VERSION_CODES.O)
    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        lifecycleScope.launch {
            while (isActive) {
                val canInstall = requireActivity().packageManager.canRequestPackageInstalls()
                if (canInstall) {
                    findNavController().navigateSafely(R.id.action_InstallPermissionFragment_to_NearpayInstallFragment)
                }
                delay(50)
                ensureActive()
            }
        }

        binding.allowBtn.setOnClickListener {
            startActivity(
                Intent(
                    Settings.ACTION_MANAGE_UNKNOWN_APP_SOURCES,
                    Uri.parse("package:${requireActivity().applicationContext.packageName}")
                )
            )
        }
    }
}