package io.nearpay.install.viewModel

import android.content.SharedPreferences
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import io.nearpay.install.core.data.dto.ResponseInstallUrlDto
import io.nearpay.install.core.data.remote.ApiResponse
import io.nearpay.install.core.data.remote.ServiceApi
import io.nearpay.install.core.utils.UrlManager
import io.nearpay.install.ui.InstallActivity
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch

internal class NearpayInstallViewModel : ViewModel() {

    private lateinit var urlManager: UrlManager
    val response: StateFlow<ApiResponse<ResponseInstallUrlDto>?>
        get() = if (this::urlManager.isInitialized) {
            urlManager.response
        } else {
            MutableStateFlow(null)
        }

    fun initializeUrlManager(sharedPreferences: SharedPreferences, serviceApi: ServiceApi) {
        if (!this::urlManager.isInitialized) {
            urlManager = UrlManager(
                sharedPreferences,
                serviceApi,
                InstallActivity.installUrlPath
            )
        }
    }

    fun getUrl() = viewModelScope.launch {
        if (::urlManager.isInitialized) {
            urlManager.getInstallUrl()
        }
    }

}