/*
  Copyright 2013 the original author or authors.

  Licensed under the Apache License, Version 2.0 the "License";
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package io.neba.api.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.ANNOTATION_TYPE;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * <p>
 * Excludes a field from the resource-to-model mapping. The annotated field's value is not
 * resolved from the {@link org.apache.sling.api.resource.Resource}. Note: Fields annotated with javax.inject.Inject
 * are automatically considered {@link Unmapped}, thus this annotation is not required for such fields.
 * </p>
 *
 * <h2>Example</h2>
 *
 * <pre>
 * &#64;{@link ResourceModel}(types = "/my/resource/type")
 * public class MyModel {
 *    &#64;Unmapped
 *    private String something;
 * }
 * </pre>
 *
 * @author Olaf Otto
 * @since 1.0.0
 */
@Documented
@Retention(RUNTIME)
@Target({FIELD, ANNOTATION_TYPE})
public @interface Unmapped {
}