/*
 * Decompiled with CFR 0.152.
 */
package io.neba.spring.blueprint;

import io.neba.spring.mvc.MvcServlet;
import io.neba.spring.resourcemodels.registration.SpringModelRegistrar;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

abstract class ContextShutdownHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SpringModelRegistrar modelRegistrar;
    @Autowired
    private MvcServlet dispatcherServlet;

    ContextShutdownHandler() {
    }

    void handleStop(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Method argument bundle must not be null.");
        }
        this.logger.info("Removing infrastructure for bundle: " + bundle + "...");
        this.modelRegistrar.unregister(bundle);
        this.dispatcherServlet.disableMvc(bundle);
        this.logger.info("Infrastructure for {} removed.", (Object)bundle);
    }
}

