/*
 * Decompiled with CFR 0.152.
 */
package io.neba.spring.blueprint;

import io.neba.spring.blueprint.ContextShutdownHandler;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.gemini.blueprint.context.BundleContextAware;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class SlingOsgiBundleShutdownHandler
extends ContextShutdownHandler
implements SynchronousBundleListener,
BundleContextAware {
    private BundleContext context;

    @Async
    public void bundleChanged(BundleEvent event) {
        if (this.isRemoveEvent(event)) {
            event.getBundle().getBundleContext().removeBundleListener((BundleListener)this);
            this.handleStop(event.getBundle());
        }
    }

    private boolean isRemoveEvent(BundleEvent event) {
        return event.getType() == 256;
    }

    @PostConstruct
    public void startListening() {
        this.context.addBundleListener((BundleListener)this);
    }

    @PreDestroy
    public void stopListening() {
        this.context.removeBundleListener((BundleListener)this);
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.context = bundleContext;
    }
}

