/*
 * Decompiled with CFR 0.152.
 */
package io.neba.spring.mvc;

import io.neba.spring.mvc.NebaViewResolver;
import io.neba.spring.mvc.RequestPathInfoArgumentResolver;
import io.neba.spring.mvc.ResourceParamArgumentResolver;
import io.neba.spring.mvc.ResourceResolverArgumentResolver;
import io.neba.spring.mvc.SlingMultipartResolver;
import io.neba.spring.web.WebApplicationContextAdapter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.servlets.ServletResolver;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.BeanNameUrlHandlerMapping;
import org.springframework.web.servlet.mvc.HttpRequestHandlerAdapter;
import org.springframework.web.servlet.mvc.annotation.ResponseStatusExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;

public class BundleSpecificDispatcherServlet
extends DispatcherServlet
implements ApplicationListener<ApplicationEvent> {
    private final ServletConfig servletConfig;
    private final ConfigurableListableBeanFactory factory;
    private final ServletResolver servletResolver;
    private boolean initialized = false;

    BundleSpecificDispatcherServlet(ServletConfig servletConfig, ServletResolver servletResolver, ConfigurableListableBeanFactory factory) {
        if (servletConfig == null) {
            throw new IllegalArgumentException("Constructor parameter servletConfig must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("method parameter factory must not be null");
        }
        if (servletResolver == null) {
            throw new IllegalArgumentException("method parameter servletResolver must not be null");
        }
        this.servletConfig = servletConfig;
        this.factory = factory;
        this.servletResolver = servletResolver;
        this.setPublishEvents(true);
        this.setDispatchOptionsRequest(true);
        this.setDispatchTraceRequest(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(@Nonnull ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            BundleSpecificDispatcherServlet bundleSpecificDispatcherServlet = this;
            synchronized (bundleSpecificDispatcherServlet) {
                ApplicationContext applicationContext = ((ContextRefreshedEvent)event).getApplicationContext();
                this.setApplicationContext((ApplicationContext)new WebApplicationContextAdapter(applicationContext, this.servletConfig.getServletContext()));
                this.configureMultipartResolver();
                this.configureExceptionResolvers();
                this.configureHandlerAdapters();
                this.registerCustomArgumentResolvers();
                this.configureHandlerMappings();
                this.addNebaViewResolver();
                this.onRefresh(applicationContext);
                this.initialized = true;
            }
        }
    }

    private void registerCustomArgumentResolvers() {
        this.getBean(RequestMappingHandlerAdapter.class).ifPresent(adapter -> {
            List argumentResolvers = adapter.getArgumentResolvers();
            if (argumentResolvers == null) {
                throw new IllegalStateException("No argument resolvers found in " + adapter + ". It appears the handler was not initialized by the application context.");
            }
            LinkedList<Object> resolvers = new LinkedList<Object>();
            resolvers.add(new RequestPathInfoArgumentResolver());
            resolvers.add(new ResourceResolverArgumentResolver());
            resolvers.add(new ResourceParamArgumentResolver());
            resolvers.addAll(argumentResolvers);
            adapter.setArgumentResolvers(resolvers);
        });
    }

    private void configureHandlerAdapters() {
        Map handlerAdapters = this.factory.getBeansOfType(HandlerAdapter.class);
        if (handlerAdapters.isEmpty()) {
            this.defineBean(HttpRequestHandlerAdapter.class);
            this.defineBean(RequestMappingHandlerAdapter.class);
        }
    }

    private void configureExceptionResolvers() {
        DefaultHandlerExceptionResolver defaultResolver;
        Map resolvers = this.factory.getBeansOfType(HandlerExceptionResolver.class);
        if (resolvers.isEmpty()) {
            this.defineBean(ExceptionHandlerExceptionResolver.class);
            this.defineBean(ResponseStatusExceptionResolver.class);
            defaultResolver = this.defineBean(DefaultHandlerExceptionResolver.class);
        } else {
            defaultResolver = this.getBean(DefaultHandlerExceptionResolver.class).orElse(null);
        }
        if (defaultResolver != null) {
            defaultResolver.setWarnLogCategory("mvc");
        }
    }

    private void configureHandlerMappings() {
        Map handlerMappings = this.factory.getBeansOfType(HandlerMapping.class);
        if (handlerMappings.isEmpty()) {
            this.defineBean(BeanNameUrlHandlerMapping.class);
            this.defineBean(RequestMappingHandlerMapping.class);
        }
    }

    private void addNebaViewResolver() {
        this.factory.registerSingleton(this.generateBeanNameFor(NebaViewResolver.class), (Object)new NebaViewResolver(this.servletResolver));
    }

    private void configureMultipartResolver() {
        if (!this.hasBean(MultipartResolver.class)) {
            this.defineBean(SlingMultipartResolver.class, "multipartResolver");
        }
    }

    private String generateBeanNameFor(Class<?> type) {
        return type.getName() + "#" + "0";
    }

    private <T> T defineBean(Class<T> type) {
        return this.defineBean(type, this.generateBeanNameFor(type));
    }

    private <T> T defineBean(Class<T> type, String beanName) {
        Object bean = this.factory.createBean(type);
        this.factory.registerSingleton(beanName, bean);
        return (T)bean;
    }

    private boolean hasBean(Class<?> type) {
        return !this.factory.getBeansOfType(type).isEmpty();
    }

    private <T> Optional<T> getBean(Class<T> beanType) {
        try {
            return Optional.of(this.factory.getBean(beanType));
        }
        catch (NoSuchBeanDefinitionException ex) {
            return Optional.empty();
        }
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public boolean hasHandlerFor(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Method argument request must not be null.");
        }
        if (!this.initialized) {
            return false;
        }
        try {
            return super.getHandler(request) != null;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to lookup a handler for " + request + ".", e);
        }
    }
}

