/*
 * Decompiled with CFR 0.152.
 */
package io.neba.spring.mvc;

import io.neba.spring.mvc.SlingMultipartFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class MultipartSlingHttpServletRequest
extends SlingHttpServletRequestWrapper
implements MultipartHttpServletRequest {
    static final String CONTENT_TYPE = "Content-Type";

    public MultipartSlingHttpServletRequest(SlingHttpServletRequest wrappedRequest) {
        super(wrappedRequest);
    }

    public Iterator<String> getFileNames() {
        RequestParameterMap requestParameterMap = this.getRequestParameterMap();
        ArrayList names = new ArrayList(requestParameterMap.size());
        for (Map.Entry entry : requestParameterMap.entrySet()) {
            RequestParameter[] params = (RequestParameter[])entry.getValue();
            if (params == null || params.length <= 0 || params[0].isFormField()) continue;
            names.add(entry.getKey());
        }
        return names.iterator();
    }

    public MultipartFile getFile(String name) {
        RequestParameter requestParameter = this.getRequestParameter(name);
        SlingMultipartFile file = null;
        if (requestParameter != null && !requestParameter.isFormField()) {
            file = new SlingMultipartFile(name, requestParameter);
        }
        return file;
    }

    public List<MultipartFile> getFiles(String name) {
        RequestParameter[] requestParameters = this.getRequestParameters(name);
        ArrayList<MultipartFile> files = new ArrayList<MultipartFile>();
        if (requestParameters != null) {
            for (RequestParameter parameter : requestParameters) {
                if (parameter.isFormField()) continue;
                files.add(new SlingMultipartFile(name, parameter));
            }
        }
        return files;
    }

    public Map<String, MultipartFile> getFileMap() {
        RequestParameterMap requestParameterMap = this.getRequestParameterMap();
        HashMap<String, MultipartFile> files = new HashMap<String, MultipartFile>(requestParameterMap.size());
        for (Map.Entry entry : requestParameterMap.entrySet()) {
            RequestParameter[] params = (RequestParameter[])entry.getValue();
            if (params == null || params.length <= 0) continue;
            for (RequestParameter parameter : params) {
                if (parameter.isFormField()) continue;
                files.put((String)entry.getKey(), new SlingMultipartFile((String)entry.getKey(), parameter));
            }
        }
        return files;
    }

    public MultiValueMap<String, MultipartFile> getMultiFileMap() {
        RequestParameterMap requestParameterMap = this.getRequestParameterMap();
        LinkedMultiValueMap fileMap = new LinkedMultiValueMap(requestParameterMap.size());
        for (Map.Entry entry : requestParameterMap.entrySet()) {
            RequestParameter[] params = (RequestParameter[])entry.getValue();
            if (params == null || params.length <= 0) continue;
            ArrayList<SlingMultipartFile> files = new ArrayList<SlingMultipartFile>(params.length);
            for (RequestParameter parameter : params) {
                if (parameter.isFormField()) continue;
                files.add(new SlingMultipartFile((String)entry.getKey(), parameter));
            }
            if (files.isEmpty()) continue;
            fileMap.put(entry.getKey(), files);
        }
        return fileMap;
    }

    public String getMultipartContentType(String name) {
        RequestParameter requestParameter = this.getRequestParameter(name);
        String contentType = null;
        if (requestParameter != null && !requestParameter.isFormField()) {
            contentType = requestParameter.getContentType();
        }
        return contentType;
    }

    public HttpHeaders getMultipartHeaders(String name) {
        String contentType = this.getMultipartContentType(name);
        if (contentType != null) {
            HttpHeaders headers = new HttpHeaders();
            headers.add(CONTENT_TYPE, contentType);
            return headers;
        }
        return null;
    }

    public HttpHeaders getRequestHeaders() {
        HttpHeaders headers = new HttpHeaders();
        Enumeration headerNames = this.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            headers.put(headerName, Collections.list(this.getHeaders(headerName)));
        }
        return headers;
    }

    public HttpMethod getRequestMethod() {
        return HttpMethod.valueOf((String)this.getSlingRequest().getMethod());
    }
}

