/*
 * Decompiled with CFR 0.152.
 */
package io.neba.spring.mvc;

import io.neba.spring.mvc.SlingRedirectView;
import io.neba.spring.mvc.SlingServletView;
import java.util.Locale;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.ServletResolver;
import org.springframework.core.Ordered;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.view.InternalResourceView;

public class NebaViewResolver
implements ViewResolver,
Ordered {
    private final ServletResolver servletResolver;

    public NebaViewResolver(ServletResolver servletResolver) {
        if (servletResolver == null) {
            throw new IllegalArgumentException("Method argument servletResolver must not be null.");
        }
        this.servletResolver = servletResolver;
    }

    public View resolveViewName(String viewName, Locale locale) {
        if (viewName == null) {
            throw new IllegalArgumentException("Method argument viewName must not be null.");
        }
        if (viewName.startsWith("redirect:")) {
            String redirectUrl = viewName.substring("redirect:".length());
            return new SlingRedirectView(redirectUrl, true, true);
        }
        if (viewName.startsWith("forward:")) {
            String forwardUrl = viewName.substring("forward:".length());
            return new InternalResourceView(forwardUrl);
        }
        return this.resolveScriptingView(viewName);
    }

    private SlingServletView resolveScriptingView(String resourceType) {
        ResourceResolver resourceResolver = ((SlingHttpServletRequest)((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest()).getResourceResolver();
        String currentResourceType = resourceType;
        do {
            String defaultScriptName;
            Servlet servlet;
            int separatorPos;
            if ((separatorPos = currentResourceType.lastIndexOf(47)) == -1 || (servlet = this.getServlet(resourceResolver, currentResourceType, defaultScriptName = currentResourceType.substring(separatorPos))) == null) continue;
            return new SlingServletView(resourceType, servlet);
        } while ((currentResourceType = resourceResolver.getParentResourceType(currentResourceType)) != null);
        return null;
    }

    private Servlet getServlet(ResourceResolver resourceResolver, String type, String defaultScriptName) {
        try {
            return this.servletResolver.resolveServlet(resourceResolver, type + defaultScriptName);
        }
        catch (SlingException e) {
            return null;
        }
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }
}

