/*
 * Decompiled with CFR 0.152.
 */
package io.neba.spring.mvc;

import io.neba.spring.api.ResourceParam;
import io.neba.spring.mvc.MissingAdapterException;
import io.neba.spring.mvc.UnresolvableResourceException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class ResourceParamArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        return this.getParameterAnnotation(parameter) != null;
    }

    private ResourceParam getParameterAnnotation(MethodParameter parameter) {
        return (ResourceParam)parameter.getParameterAnnotation(ResourceParam.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer container, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        boolean required;
        String parameterName;
        Object nativeRequest = webRequest.getNativeRequest();
        if (!(nativeRequest instanceof SlingHttpServletRequest)) {
            throw new IllegalStateException("Expected a " + SlingHttpServletRequest.class.getName() + " request, but got: " + nativeRequest + ".");
        }
        SlingHttpServletRequest request = (SlingHttpServletRequest)nativeRequest;
        ResourceParam resourceParam = this.getParameterAnnotation(parameter);
        String resourcePath = this.resolveResourcePath(request, resourceParam, parameterName = this.resolveParameterName(parameter, resourceParam), required = resourceParam.required() && StringUtils.isEmpty((CharSequence)resourceParam.defaultValue()));
        if (resourcePath == null) {
            return null;
        }
        ResourceResolver resolver = request.getResourceResolver();
        Resource resource = resolver.resolve((HttpServletRequest)request, resourcePath);
        if (ResourceUtil.isNonExistingResource((Resource)resource)) {
            if (required) {
                throw new UnresolvableResourceException("Unable to resolve resource " + resourcePath + " for the required parameter '" + parameterName + "'.");
            }
            return null;
        }
        if (parameter.getParameterType().isAssignableFrom(Resource.class)) {
            return resource;
        }
        Object adapted = resource.adaptTo(parameter.getParameterType());
        if (adapted == null && required) {
            throw new MissingAdapterException("Unable to adapt " + resource + " to " + parameter.getParameterType() + " for required parameter '" + parameterName + "'.");
        }
        return adapted;
    }

    private String resolveResourcePath(SlingHttpServletRequest request, ResourceParam resourceParam, String parameterName, boolean required) throws MissingServletRequestParameterException {
        String resourcePath = request.getParameter(parameterName);
        if (StringUtils.isEmpty((CharSequence)resourcePath)) {
            resourcePath = resourceParam.defaultValue();
        }
        if (StringUtils.isEmpty((CharSequence)resourcePath)) {
            if (required) {
                throw new MissingServletRequestParameterException(parameterName, String.class.getSimpleName());
            }
            return null;
        }
        if (!StringUtils.isEmpty((CharSequence)resourceParam.append())) {
            resourcePath = resourcePath + resourceParam.append();
        }
        return resourcePath;
    }

    private String resolveParameterName(MethodParameter parameter, ResourceParam param) {
        String parameterName = param.value();
        if (StringUtils.isEmpty((CharSequence)parameterName)) {
            parameterName = parameter.getParameterName();
        }
        return parameterName;
    }
}

