/*
 * Decompiled with CFR 0.152.
 */
package io.neba.spring.web;

import io.neba.spring.web.BackgroundServletRequestWrapper;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.bgservlets.BackgroundHttpServletRequest;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.filter.RequestContextFilter;

public class NebaRequestContextFilter
extends RequestContextFilter {
    private static final boolean IS_BGSERVLETS_PRESENT = ClassUtils.isPresent((String)"org.apache.sling.bgservlets.BackgroundHttpServletRequest", (ClassLoader)NebaRequestContextFilter.class.getClassLoader());
    private boolean threadContextInheritable = false;

    public void setThreadContextInheritable(boolean threadContextInheritable) {
        this.threadContextInheritable = threadContextInheritable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        ServletRequestAttributes attributes = this.createServletRequestAttributes(request);
        this.initContextHolders(request, attributes);
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            this.resetContextHolders();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cleared thread-bound request context: " + request));
            }
            attributes.requestCompleted();
        }
    }

    private ServletRequestAttributes createServletRequestAttributes(HttpServletRequest request) {
        if (IS_BGSERVLETS_PRESENT && request instanceof BackgroundHttpServletRequest) {
            return new ServletRequestAttributes((HttpServletRequest)new BackgroundServletRequestWrapper(request));
        }
        return new ServletRequestAttributes(request);
    }

    private void initContextHolders(HttpServletRequest request, ServletRequestAttributes requestAttributes) {
        LocaleContextHolder.setLocale((Locale)request.getLocale(), (boolean)this.threadContextInheritable);
        RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes, (boolean)this.threadContextInheritable);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Bound request context to thread: " + request));
        }
    }

    private void resetContextHolders() {
        LocaleContextHolder.resetLocaleContext();
        RequestContextHolder.resetRequestAttributes();
    }
}

