/*
 * Decompiled with CFR 0.152.
 */
package io.neba.api.resourcemodels;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public interface Lazy<T> {
    @Nonnull
    public Optional<T> asOptional();

    @Nonnull
    default public T get() {
        return this.asOptional().get();
    }

    default public boolean isPresent() {
        return this.asOptional().isPresent();
    }

    default public void ifPresent(Consumer<? super T> c) {
        this.asOptional().ifPresent(c);
    }

    @Nonnull
    default public Lazy<T> filter(Predicate<? super T> predicate) {
        return () -> this.asOptional().filter(predicate);
    }

    @Nonnull
    default public <U> Lazy<U> map(Function<? super T, ? extends U> f) {
        return () -> this.asOptional().map(f);
    }

    @Nonnull
    default public <U> Lazy<U> flatMap(Function<? super T, Lazy<U>> f) {
        Objects.requireNonNull(f);
        if (!this.isPresent()) {
            return Optional::empty;
        }
        return Objects.requireNonNull(f.apply(this.get()));
    }

    @CheckForNull
    default public T orElse(T other) {
        return this.asOptional().orElse(other);
    }

    @CheckForNull
    default public T orElseGet(Supplier<? extends T> other) {
        return this.asOptional().orElseGet(other);
    }

    @Nonnull
    default public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        return this.asOptional().orElseThrow(exceptionSupplier);
    }
}

