/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.logviewer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LogFiles.class})
public class LogFiles {
    private static final String LOG_FILE_PROPERTY = "org.apache.sling.commons.log.file";
    private static final String LOG_MANAGER_PID = "org.apache.sling.commons.log.LogManager";
    private static final String LOG_FACTORY_PID = "org.apache.sling.commons.log.LogManager.factory.config";
    private static final IOFileFilter LOGFILE_FILTER = new IOFileFilter(){

        public boolean accept(File file) {
            return file.canRead() && this.acceptFileName(file.getName());
        }

        public boolean accept(File dir, String name) {
            return this.acceptFileName(name);
        }

        private boolean acceptFileName(String fileName) {
            return fileName.endsWith(".log") || fileName.contains(".log.");
        }
    };
    @Reference
    private ConfigurationAdmin configurationAdmin;
    private BundleContext context;
    private File slingHomeDirectory;

    @Activate
    protected void activate(BundleContext context) {
        this.context = context;
        this.slingHomeDirectory = new File(this.context.getProperty("sling.home"));
    }

    private File getLogfileDirectory() throws IOException {
        Configuration logConfiguration = this.getCommonsLogConfiguration();
        File defaultLogFile = this.getConfiguredLogfile(logConfiguration);
        if (defaultLogFile != null && defaultLogFile.exists() && defaultLogFile.canRead()) {
            return defaultLogFile.getParentFile();
        }
        return null;
    }

    private File getConfiguredLogfile(Configuration logConfiguration) throws IOException {
        Dictionary properties = logConfiguration.getProperties();
        if (properties == null) {
            return null;
        }
        String logFilePath = (String)properties.get(LOG_FILE_PROPERTY);
        if (StringUtils.isEmpty((CharSequence)logFilePath)) {
            return null;
        }
        File logFile = new File(logFilePath);
        if (!logFile.isAbsolute()) {
            logFile = new File(this.slingHomeDirectory, logFilePath);
        }
        return logFile.getCanonicalFile();
    }

    public Collection<File> resolveLogFiles() throws IOException {
        File logDir = this.getLogfileDirectory();
        TreeSet<File> logFiles = new TreeSet<File>((o1, o2) -> o1.getPath().compareToIgnoreCase(o2.getPath()));
        if (logDir == null) {
            logDir = new File(this.slingHomeDirectory, "logs");
        }
        if (logDir.exists() && logDir.isDirectory()) {
            logFiles.addAll(FileUtils.listFiles((File)logDir, (IOFileFilter)LOGFILE_FILTER, (IOFileFilter)TrueFileFilter.INSTANCE));
        }
        for (File logFile : this.resolveFactoryConfiguredLogFiles()) {
            if (logFile.getParentFile().getAbsolutePath().startsWith(logDir.getAbsolutePath())) continue;
            logFiles.addAll(FileUtils.listFiles((File)logFile.getParentFile(), (IOFileFilter)LOGFILE_FILTER, (IOFileFilter)TrueFileFilter.INSTANCE));
        }
        return logFiles;
    }

    private Collection<File> resolveFactoryConfiguredLogFiles() throws IOException {
        Configuration[] configurations;
        ArrayList<File> logFiles = new ArrayList<File>();
        try {
            configurations = this.configurationAdmin.listConfigurations("(service.factoryPid=org.apache.sling.commons.log.LogManager.factory.config)");
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("Unable to obtain the log files with factory pid org.apache.sling.commons.log.LogManager.factory.config.", e);
        }
        if (configurations != null) {
            for (Configuration logConfiguration : configurations) {
                File logFile = this.getConfiguredLogfile(logConfiguration);
                if (logFile == null || !logFile.exists() || !logFile.canRead()) continue;
                logFiles.add(logFile);
            }
        }
        return logFiles;
    }

    private Configuration getCommonsLogConfiguration() throws IOException {
        return this.configurationAdmin.getConfiguration(LOG_MANAGER_PID);
    }
}

