/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.logviewer;

import io.neba.core.logviewer.LogFiles;
import io.neba.core.logviewer.TailServlet;
import io.neba.core.util.ZipFileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"felix.webconsole.label=logviewer", "service.description=Provides a Felix console plugin for monitoring and downloading logfiles.", "service.vendor=neba.io"})
public class LogfileViewerConsolePlugin
extends AbstractWebConsolePlugin {
    static final String LABEL = "logviewer";
    private static final String RESOURCES_ROOT = "/META-INF/consoleplugin/logviewer";
    private static final String DECORATED_OBJECT_FACTORY = "org.eclipse.jetty.util.DecoratedObjectFactory";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private boolean isManagingDecoratedObjectFactory = false;
    @Reference
    private TailServlet tailServlet;
    @Reference
    private LogFiles logFiles;

    public void init() throws ServletException {
        super.init();
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            this.injectDecoratorObjectFactoryIntoServletContext();
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.tailServlet.init(this.getServletConfig());
        }
        catch (Throwable t) {
            this.logger.error("Unable to initialize the tail servlet - the log viewer will not be available", t);
            throw new ServletException("Unable to initialize the tail servlet - the log viewer will not be available", t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    public void destroy() {
        super.destroy();
        this.removeDecoratorObjectFactoryFromServletContext();
        this.tailServlet.destroy();
    }

    public String getCategory() {
        return "NEBA";
    }

    public URL getResource(String path) {
        URL url = null;
        String internalPath = StringUtils.substringAfter((String)path, (String)("/" + this.getLabel()));
        if (StringUtils.startsWith((CharSequence)internalPath, (CharSequence)"/static/")) {
            url = ((Object)((Object)this)).getClass().getResource(RESOURCES_ROOT + internalPath);
        }
        return url;
    }

    protected void renderContent(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.writeScriptIncludes(res);
        this.writeHead(res);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String suffix = StringUtils.substringAfter((String)req.getRequestURI(), (String)(req.getServletPath() + "/" + this.getLabel()));
        if (!StringUtils.isBlank((CharSequence)suffix) && suffix.startsWith("/tail")) {
            this.tailServlet.service((ServletRequest)req, (ServletResponse)res);
            return;
        }
        if (!StringUtils.isBlank((CharSequence)suffix) && suffix.equals("/download")) {
            this.download(res, req);
            return;
        }
        super.doGet(req, res);
    }

    private void injectDecoratorObjectFactoryIntoServletContext() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ServletContext servletContext = this.getServletContext();
        if (servletContext.getAttribute(DECORATED_OBJECT_FACTORY) != null || !this.isDecoratedObjectFactoryAvailable()) {
            return;
        }
        servletContext.setAttribute(DECORATED_OBJECT_FACTORY, Class.forName(DECORATED_OBJECT_FACTORY).newInstance());
        this.isManagingDecoratedObjectFactory = true;
    }

    private boolean isDecoratedObjectFactoryAvailable() {
        try {
            Class.forName(DECORATED_OBJECT_FACTORY, false, ((Object)((Object)this)).getClass().getClassLoader());
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private void removeDecoratorObjectFactoryFromServletContext() {
        if (this.isManagingDecoratedObjectFactory) {
            this.getServletContext().removeAttribute(DECORATED_OBJECT_FACTORY);
        }
    }

    private void writeHead(HttpServletResponse res) throws IOException {
        StringBuilder options = new StringBuilder(1024);
        this.logFiles.resolveLogFiles().forEach(file -> options.append("<option value=\"").append(file.getAbsolutePath()).append("\" ").append("title=\"").append(file.getAbsolutePath()).append("\">").append(file.getParentFile().getName()).append('/').append(file.getName()).append("</option>"));
        this.writeHeadFromTemplate(res, options.toString());
        this.writeBodyFromTemplate(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(HttpServletResponse res, HttpServletRequest req) throws IOException {
        res.setContentType("application/zip");
        res.setHeader("Content-Disposition", "attachment;filename=logfiles-" + req.getServerName() + ".zip");
        ZipOutputStream zos = new ZipOutputStream((OutputStream)res.getOutputStream());
        try {
            for (File file : this.logFiles.resolveLogFiles()) {
                ZipEntry ze = new ZipEntry(ZipFileUtil.toZipFileEntryName(file));
                zos.putNextEntry(ze);
                FileInputStream in = new FileInputStream(file);
                try {
                    IOUtils.copy((InputStream)in, (OutputStream)zos);
                    zos.closeEntry();
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
            zos.finish();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)zos);
        }
    }

    private void writeHeadFromTemplate(HttpServletResponse response, Object ... templateArgs) throws IOException {
        String template = this.readTemplate("head.html");
        response.getWriter().printf(template, templateArgs);
    }

    private void writeBodyFromTemplate(HttpServletResponse response) throws IOException {
        String template = this.readTemplate("body.html");
        response.getWriter().write(template);
    }

    private String readTemplate(String templateName) {
        return this.readTemplateFile("/META-INF/consoleplugin/logviewer/templates/" + templateName);
    }

    private void writeScriptIncludes(HttpServletResponse response) throws IOException {
        response.getWriter().write("<script src=\"" + this.getLabel() + "/static/script.js\"></script>");
        response.getWriter().write("<script src=\"" + this.getLabel() + "/static/encoding-indexes.js\"></script>");
        response.getWriter().write("<script src=\"" + this.getLabel() + "/static/encoding.js\"></script>");
    }

    public String getTitle() {
        return "View logfiles";
    }

    public String getLabel() {
        return LABEL;
    }
}

