/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.logviewer;

import io.neba.core.logviewer.LogFiles;
import io.neba.core.logviewer.Tail;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TailSocket
extends WebSocketAdapter {
    private static final Pattern TAIL_COMMAND = Pattern.compile("tail:(([0-9]+\\.)?[0-9]+)mb:(.+)");
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final LogFiles logFiles;
    private Tail tail;

    TailSocket(LogFiles logFiles) {
        if (logFiles == null) {
            throw new IllegalArgumentException("Method argument logFiles must not be null.");
        }
        this.logFiles = logFiles;
    }

    public void onWebSocketClose(int statusCode, String reason) {
        this.stopTail();
        this.executorService.shutdownNow();
        super.onWebSocketClose(statusCode, reason);
    }

    public void onWebSocketText(String message) {
        if (this.isPing(message)) {
            this.sendPong();
            return;
        }
        Matcher m = TAIL_COMMAND.matcher(message);
        if (!m.matches()) {
            this.logger.warn("Unsupported command format '" + message + "', must match " + TAIL_COMMAND.pattern() + ", ignoring the command.");
            return;
        }
        try {
            float including = NumberUtils.toFloat((String)m.group(1));
            String path = m.group(m.groupCount());
            File file = this.resolveLogFile(path);
            if (file == null) {
                return;
            }
            long bytesToTail = Math.round(including * 1024.0f * 1024.0f);
            this.tail(file, bytesToTail);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void sendPong() {
        this.getRemote().sendStringByFuture("pong");
    }

    private boolean isPing(String message) {
        return "ping".equals(message);
    }

    private void tail(File file, long bytesToTail) throws IOException {
        this.stopTail();
        this.tail = new Tail(this.getRemote(), file, bytesToTail);
        this.executorService.execute(this.tail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopTail() {
        if (this.tail != null) {
            Tail tail = this.tail;
            synchronized (tail) {
                this.tail.stop();
                this.tail.notify();
                this.tail = null;
            }
        }
    }

    private File resolveLogFile(String path) throws IOException {
        return this.logFiles.resolveLogFiles().stream().filter(f -> f.getAbsolutePath().equals(path)).findFirst().orElse(null);
    }
}

