/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.adaptation;

import io.neba.core.resourcemodels.adaptation.AmbiguousModelAssociationException;
import io.neba.core.resourcemodels.caching.ResourceModelCaches;
import io.neba.core.resourcemodels.mapping.ResourceToModelMapper;
import io.neba.core.resourcemodels.registration.LookupResult;
import io.neba.core.resourcemodels.registration.ModelRegistry;
import io.neba.core.util.Key;
import io.neba.core.util.OsgiModelSource;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ResourceToModelAdapter.class})
public class ResourceToModelAdapter
implements AdapterFactory {
    @Reference
    private ModelRegistry registry;
    @Reference
    private ResourceToModelMapper mapper;
    @Reference
    private ResourceModelCaches caches;

    public <T> T getAdapter(@Nonnull Object adaptable, @Nonnull Class<T> target) {
        if (!(adaptable instanceof Resource)) {
            return null;
        }
        Resource resource = (Resource)adaptable;
        Key key = ResourceModelCaches.key(target);
        Optional cachedModel = this.caches.lookup(resource, key);
        if (cachedModel == Optional.empty()) {
            return null;
        }
        if (cachedModel != null) {
            return cachedModel.get();
        }
        Collection<LookupResult> models = this.registry.lookupMostSpecificModels(resource, target);
        if (models == null || models.isEmpty()) {
            this.caches.store(resource, key, Optional.empty());
            return null;
        }
        if (models.size() != 1) {
            throw new AmbiguousModelAssociationException("There is more than one model that maps " + resource.getPath() + " to " + target.getName() + ": " + StringUtils.join(models, (String)", ") + ".");
        }
        OsgiModelSource<?> source = models.iterator().next().getSource();
        Object model = this.mapper.map(resource, source);
        this.caches.store(resource, key, Optional.of(model));
        return (T)model;
    }
}

