/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.adaptation;

import io.neba.core.resourcemodels.adaptation.ResourceToModelAdapter;
import io.neba.core.resourcemodels.registration.ModelRegistry;
import io.neba.core.util.OsgiModelSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ResourceToModelAdapterUpdater.class})
public class ResourceToModelAdapterUpdater {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private ModelRegistry registry;
    @Reference
    private ResourceToModelAdapter adapter;
    private BundleContext context = null;
    private ServiceRegistration resourceToModelAdapterRegistration = null;
    private ExecutorService executorService;

    @Activate
    protected void activate(BundleContext context) {
        this.context = context;
        this.executorService = Executors.newSingleThreadExecutor();
        this.registerModelAdapter();
    }

    @Deactivate
    protected void deActivate() {
        this.executorService.shutdownNow();
    }

    public void refresh() {
        this.executorService.execute(() -> {
            if (this.isModelAdapterUpdatable()) {
                this.updateModelAdapter();
            }
        });
    }

    void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    private boolean isModelAdapterUpdatable() {
        int bundleState = this.context.getBundle().getState();
        return bundleState == 32 || bundleState == 8;
    }

    private void updateModelAdapter() {
        this.unregisterModelAdapter();
        this.registerModelAdapter();
    }

    private void registerModelAdapter() {
        Dictionary<String, Object> properties = this.createResourceToModelAdapterProperties();
        String serviceClassName = AdapterFactory.class.getName();
        this.resourceToModelAdapterRegistration = this.context.registerService(serviceClassName, (Object)this.adapter, properties);
    }

    private void unregisterModelAdapter() {
        try {
            this.resourceToModelAdapterRegistration.unregister();
        }
        catch (IllegalStateException e) {
            this.logger.info("The resource to model adapter was already unregistered, ignoring.", (Throwable)e);
        }
    }

    private Dictionary<String, Object> createResourceToModelAdapterProperties() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        Set<String> fullyQualifiedNamesOfRegisteredModels = this.getAdapterTypeNames();
        ((Dictionary)properties).put("adapters", fullyQualifiedNamesOfRegisteredModels.toArray());
        ((Dictionary)properties).put("adaptables", new String[]{Resource.class.getName()});
        ((Dictionary)properties).put("service.vendor", "neba.io");
        ((Dictionary)properties).put("service.description", "Adapts Resources to @ResourceModels.");
        return properties;
    }

    private Set<String> getAdapterTypeNames() {
        List<OsgiModelSource<?>> modelSources = this.registry.getModelSources();
        HashSet<String> modelNames = new HashSet<String>();
        for (OsgiModelSource<?> source : modelSources) {
            Class<?> c = source.getModelType();
            modelNames.add(c.getName());
            modelNames.addAll(this.toClassnameList(ClassUtils.getAllInterfaces(c)));
            List allSuperclasses = ClassUtils.getAllSuperclasses(c);
            allSuperclasses.remove(allSuperclasses.size() - 1);
            modelNames.addAll(this.toClassnameList(allSuperclasses));
        }
        return modelNames;
    }

    private Collection<String> toClassnameList(List<Class<?>> l) {
        ArrayList<String> classNames = new ArrayList<String>(l.size());
        classNames.addAll(l.stream().map(Class::getName).collect(Collectors.toList()));
        return classNames;
    }
}

