/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.caching;

import io.neba.api.spi.ResourceModelCache;
import io.neba.core.util.Key;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ResourceModelCache.class, Filter.class}, property={"service.vendor=neba.io", "sling.filter.scope=REQUEST", "sling.filter.scope=ERROR", "service.ranking:Integer=9000"})
@Designate(ocd=Configuration.class)
public class RequestScopedResourceModelCache
implements ResourceModelCache,
Filter {
    private final ThreadLocal<Map<Object, Object>> cacheHolder = new ThreadLocal();
    private final ThreadLocal<SlingHttpServletRequest> requestHolder = new ThreadLocal();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Configuration configuration;

    @Activate
    protected void activate(Configuration configuration) {
        this.configuration = configuration;
    }

    public <T> T get(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Method argument key must not be null.");
        }
        if (!this.configuration.enabled()) {
            return null;
        }
        Map<Object, Object> cache = this.cacheHolder.get();
        if (cache == null) {
            this.logger.debug("No cache found, the cache will not be used.");
            return null;
        }
        if (this.configuration.safeMode()) {
            return (T)cache.get(this.createSafeModeKey(key));
        }
        return (T)cache.get(key);
    }

    public <T> void put(@Nonnull Resource resource, @CheckForNull T model, @Nonnull Object key) {
        if (resource == null) {
            throw new IllegalArgumentException("Method argument resource must not be null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("Method argument key must not be null.");
        }
        if (model == null) {
            return;
        }
        if (!this.configuration.enabled()) {
            return;
        }
        Map<Object, Object> cache = this.cacheHolder.get();
        if (cache == null) {
            this.logger.debug("No cache found, the cache will not be used.");
            return;
        }
        if (this.configuration.safeMode()) {
            cache.put(this.createSafeModeKey(key), model);
            return;
        }
        cache.put(key, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.configuration.enabled()) {
            chain.doFilter(request, response);
            return;
        }
        if (!(request instanceof SlingHttpServletRequest)) {
            throw new IllegalStateException("Expected a " + SlingHttpServletRequest.class.getName() + ", but got: " + request + ".");
        }
        SlingHttpServletRequest slingHttpServletRequest = (SlingHttpServletRequest)request;
        this.requestHolder.set(slingHttpServletRequest);
        this.cacheHolder.set(new HashMap(1024));
        try {
            chain.doFilter((ServletRequest)slingHttpServletRequest, response);
        }
        finally {
            this.cacheHolder.remove();
            this.requestHolder.remove();
        }
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    private Object createSafeModeKey(Object key) {
        SlingHttpServletRequest request = this.requestHolder.get();
        if (request == null) {
            return key;
        }
        RequestPathInfo requestPathInfo = request.getRequestPathInfo();
        return new Key(key, new Key(StringUtils.substringBefore((String)requestPathInfo.getResourcePath(), (String)"/jcr:content"), requestPathInfo.getSelectorString(), requestPathInfo.getExtension(), requestPathInfo.getSuffix(), request.getQueryString()));
    }

    @ObjectClassDefinition(name="NEBA request-scoped resource model cache", description="Provides a request-scoped resource model cache")
    public static @interface Configuration {
        @AttributeDefinition(name="Enabled", description="Activates the request-scoped cache for resource models.")
        public boolean enabled() default true;

        @AttributeDefinition(name="Safemode", description="In safemode, caching is sensitive to the current page resource and request parameters such as selectors, suffix, extension and the query string. Should @ResourceModels erroneously cache such state, e.g. by initializing the corresponding value once in a @AfterMapping method, safemode prevents errors caused when performing subsequent internal changes to the request state (e.g. during forwards and includes). Note that enabling this feature is likely to a significant negative performance impact. It is highly recommended to disable safemode in favor of safe-to-cache @ResourceModels.")
        public boolean safeMode() default false;
    }
}

