/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.caching;

import io.neba.api.spi.ResourceModelCache;
import io.neba.core.resourcemodels.metadata.ResourceModelMetaDataRegistrar;
import io.neba.core.util.Key;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={ResourceModelCaches.class})
public class ResourceModelCaches {
    @Reference
    private ResourceModelMetaDataRegistrar metaDataRegistrar;
    @Reference(policy=ReferencePolicy.DYNAMIC, bind="bind", unbind="unbind")
    private final List<ResourceModelCache> caches = new ArrayList<ResourceModelCache>();

    public <T> Optional<T> lookup(@Nonnull Resource resource, @Nonnull Key key) {
        if (resource == null) {
            throw new IllegalArgumentException("Method argument resource must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("Method argument key must not be null");
        }
        if (this.caches.isEmpty()) {
            return null;
        }
        Key lookupKey = this.key(resource, key);
        for (ResourceModelCache cache : this.caches) {
            Optional model = (Optional)cache.get((Object)lookupKey);
            if (model == Optional.empty()) {
                return model;
            }
            if (model == null) continue;
            this.metaDataRegistrar.get(model.get().getClass()).getStatistics().countCacheHit();
            return model;
        }
        return null;
    }

    public <T> void store(@Nonnull Resource resource, @Nonnull Key key, @Nonnull Optional<T> model) {
        if (resource == null) {
            throw new IllegalArgumentException("Method argument resource must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("Method argument key must not be null");
        }
        if (model == null) {
            throw new IllegalArgumentException("Method argument model must not be null");
        }
        if (this.caches.isEmpty()) {
            return;
        }
        Key lookupKey = this.key(resource, key);
        for (ResourceModelCache cache : this.caches) {
            cache.put(resource, model, (Object)lookupKey);
        }
    }

    protected void bind(ResourceModelCache cache) {
        this.caches.add(cache);
    }

    protected void unbind(ResourceModelCache cache) {
        if (cache == null) {
            return;
        }
        this.caches.remove(cache);
    }

    private <T> Key key(Resource resource, Key key) {
        return new Key(resource.getPath(), key, resource.getResourceType(), resource.getResourceResolver().hashCode());
    }

    public static Key key(Object ... contents) {
        return new Key(contents);
    }
}

