/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.factory;

import io.neba.api.annotations.ResourceModel;
import io.neba.api.spi.ResourceModelFactory;
import io.neba.core.resourcemodels.factory.ClassBasedModelDefinition;
import io.neba.core.resourcemodels.factory.ModelInstantiationException;
import io.neba.core.resourcemodels.factory.ModelInstantiator;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.Bundle;

class ModelFactory
implements ResourceModelFactory {
    private final Bundle bundle;
    private List<ResourceModelFactory.ModelDefinition> modelDefinitions;
    private Map<ResourceModelFactory.ModelDefinition, ModelInstantiator<?>> modelMetadata;

    ModelFactory(Bundle bundle) {
        this.bundle = bundle;
        String packages = (String)this.bundle.getHeaders().get("Neba-Packages");
        this.modelDefinitions = packages == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.stream(packages.split(",")).map(String::trim).filter(StringUtils::isNotBlank).map(this::packageNameToDirectory).map(this::findClassesInDirectory).filter(Optional::isPresent).map(Optional::get).flatMap(this::streamUrls).map(this::urlToClassName).map(this::loadClass).filter(o -> o.map(c -> c.isAnnotationPresent(ResourceModel.class)).orElse(false)).map(Optional::get).map(ClassBasedModelDefinition::new).distinct().collect(Collectors.toList()));
        HashMap metaData = new HashMap();
        for (ResourceModelFactory.ModelDefinition definition : this.modelDefinitions) {
            metaData.put(definition, new ModelInstantiator(definition.getType()));
        }
        this.modelMetadata = metaData;
    }

    @Nonnull
    public Collection<ResourceModelFactory.ModelDefinition> getModelDefinitions() {
        return this.modelDefinitions;
    }

    private Optional<Enumeration<URL>> findClassesInDirectory(String directory) {
        return Optional.ofNullable(this.bundle.findEntries(directory, "*.class", true));
    }

    private String packageNameToDirectory(String packageName) {
        return '/' + packageName.replace('.', '/');
    }

    private String urlToClassName(URL url) {
        String file = url.getFile();
        String classFileName = file.substring(1, file.length() - ".class".length());
        return classFileName.replace('/', '.');
    }

    private Optional<Class<?>> loadClass(String name) {
        try {
            return Optional.of(this.bundle.loadClass(name));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    private Stream<? extends URL> streamUrls(Enumeration<URL> urls) {
        ArrayList<URL> l = new ArrayList<URL>(32);
        while (urls.hasMoreElements()) {
            l.add(urls.nextElement());
        }
        return l.stream();
    }

    @Nonnull
    public Object getModel(@Nonnull ResourceModelFactory.ModelDefinition modelDefinition) {
        ModelInstantiator<?> modelInstantiator = this.modelMetadata.get(modelDefinition);
        if (modelInstantiator == null) {
            throw new IllegalStateException("Unable to instantiate " + modelDefinition + ", there is no model metadata for this model type in this factory.");
        }
        try {
            return modelInstantiator.create(this.bundle.getBundleContext());
        }
        catch (ReflectiveOperationException e) {
            throw new ModelInstantiationException("Unable to instantiate model " + modelDefinition, e);
        }
    }
}

