/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.factory;

import io.neba.api.annotations.Filter;
import io.neba.core.resourcemodels.factory.InvalidModelException;
import io.neba.core.resourcemodels.factory.ModelInstantiationException;
import io.neba.core.resourcemodels.factory.ServiceDependency;
import io.neba.core.util.Annotations;
import io.neba.core.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.osgi.framework.BundleContext;

class ModelInstantiator<T> {
    private static final String INJECT_ANNOTATION_NAME = "javax.inject.Inject";
    private static final String POSTCONSTRUCT_ANNOTATION_NAME = "javax.annotation.PostConstruct";
    private final ModelConstructor<T> constructor;
    private final ModelServiceSetter[] setters;
    private final Method[] postConstructMethods;

    ModelInstantiator(@Nonnull Class<T> modelType) {
        this.constructor = ModelInstantiator.resolveConstructor(modelType);
        this.setters = ModelInstantiator.resolveServiceSetters(modelType);
        this.postConstructMethods = this.resolvePostConstructMethods(modelType);
    }

    @Nonnull
    public T create(@Nonnull BundleContext context) throws ReflectiveOperationException {
        T instance = this.constructor.instantiate(context);
        for (ModelServiceSetter setter : this.setters) {
            setter.set(context, instance);
        }
        for (Method m : this.postConstructMethods) {
            m.invoke(instance, new Object[0]);
        }
        return instance;
    }

    @Nonnull
    private static ModelServiceSetter[] resolveServiceSetters(@Nonnull Class<?> modelType) {
        ArrayList<ModelServiceSetter> serviceSetters = new ArrayList<ModelServiceSetter>();
        for (Method method : modelType.getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || !Annotations.annotations(method).containsName(INJECT_ANNOTATION_NAME)) continue;
            if (method.getParameterCount() != 1) {
                throw new InvalidModelException("The method " + method + " is annotated with @Inject and must thus take exactly one argument.");
            }
            Filter filter = ModelInstantiator.findFilterAnnotation(method.getParameterAnnotations()[0]);
            Type serviceType = method.getGenericParameterTypes()[0];
            ServiceDependency serviceDependency = new ServiceDependency(serviceType, modelType, filter);
            serviceSetters.add(new ModelServiceSetter(serviceDependency, method));
        }
        return serviceSetters.toArray(new ModelServiceSetter[0]);
    }

    @Nonnull
    private Method[] resolvePostConstructMethods(@Nonnull Class<T> modelType) {
        Object[] postConstructMethods = (Method[])ReflectionUtil.methodsOf(modelType).stream().filter(m -> Annotations.annotations(m).containsName(POSTCONSTRUCT_ANNOTATION_NAME)).peek(m -> {
            if (Modifier.isStatic(m.getModifiers())) {
                throw new InvalidModelException("The @PostConstruct callback '" + m + "' must not be static.");
            }
            if (m.getParameterCount() != 0) {
                throw new InvalidModelException("The @PostConstruct callback '" + m + "' must not take any arguments.");
            }
        }).peek(ReflectionUtil::makeAccessible).toArray(Method[]::new);
        ArrayUtils.reverse((Object[])postConstructMethods);
        return postConstructMethods;
    }

    @Nonnull
    private static <T> ModelConstructor<T> resolveConstructor(@Nonnull Class<T> modelType) {
        ModelConstructor constructor;
        Constructor<?> injectionConstructor = null;
        Constructor<?> defaultConstructor = null;
        for (Constructor<?> c : modelType.getConstructors()) {
            if (c.getParameterCount() == 0) {
                defaultConstructor = c;
            }
            if (!Annotations.annotations(c).containsName(INJECT_ANNOTATION_NAME)) continue;
            if (injectionConstructor != null) {
                throw new InvalidModelException("Unable to instantiate model " + modelType + ". Found more than one constructor annotated with @Inject: " + injectionConstructor + ", " + c);
            }
            injectionConstructor = c;
        }
        if (injectionConstructor != null) {
            Type[] parameters = injectionConstructor.getGenericParameterTypes();
            ServiceDependency[] serviceDependencies = new ServiceDependency[parameters.length];
            Annotation[][] parameterAnnotations = injectionConstructor.getParameterAnnotations();
            for (int i = 0; i < parameters.length; ++i) {
                Filter filter = ModelInstantiator.findFilterAnnotation(parameterAnnotations[i]);
                serviceDependencies[i] = new ServiceDependency(parameters[i], modelType, filter);
            }
            constructor = new ModelConstructor(injectionConstructor, serviceDependencies);
        } else if (defaultConstructor != null) {
            constructor = new ModelConstructor(defaultConstructor, new ServiceDependency[0]);
        } else {
            throw new InvalidModelException("The model " + modelType + " has neither a public default constructor nor a public constructor annotated with @Inject.");
        }
        return constructor;
    }

    @Nullable
    private static Filter findFilterAnnotation(@Nonnull Annotation[] annotations) {
        Annotation annotation;
        Filter filter = null;
        Annotation[] annotationArray = annotations;
        int n = annotationArray.length;
        for (int i = 0; i < n && (filter = (annotation = annotationArray[i]).annotationType() == Filter.class ? (Filter)annotation : Annotations.annotations(annotation.annotationType()).get(Filter.class)) == null; ++i) {
        }
        return filter;
    }

    private static class ModelConstructor<T> {
        private final ServiceDependency[] serviceDependencies;
        private final Constructor<T> constructor;

        ModelConstructor(@Nonnull Constructor<T> constructor, ServiceDependency ... serviceDependencies) {
            this.serviceDependencies = serviceDependencies;
            this.constructor = constructor;
        }

        @Nonnull
        T instantiate(@Nonnull BundleContext context) throws ReflectiveOperationException {
            if (this.serviceDependencies == null || this.serviceDependencies.length == 0) {
                return this.constructor.newInstance(new Object[0]);
            }
            Object[] resolvedServices = new Object[this.serviceDependencies.length];
            for (int i = 0; i < resolvedServices.length; ++i) {
                ServiceDependency serviceDependency = this.serviceDependencies[i];
                Object serviceInstance = serviceDependency.resolve(context);
                if (serviceInstance == null) {
                    throw new ModelInstantiationException("Unable to instantiate the model using '" + this.constructor + "'. The Service dependency '" + serviceDependency + "' resolved to null.");
                }
                resolvedServices[i] = serviceInstance;
            }
            return this.constructor.newInstance(resolvedServices);
        }
    }

    private static class ModelServiceSetter {
        private final ServiceDependency serviceDependency;
        private final Method setter;

        private ModelServiceSetter(@Nonnull ServiceDependency serviceDependency, @Nonnull Method setter) {
            this.serviceDependency = serviceDependency;
            this.setter = setter;
        }

        public void set(@Nonnull BundleContext context, @Nonnull Object model) throws InvocationTargetException, IllegalAccessException {
            Object serviceInstance = this.serviceDependency.resolve(context);
            if (serviceInstance == null) {
                throw new ModelInstantiationException("Unable to inject a required service dependency via '" + this.setter + "',  the Service dependency '" + this.serviceDependency + "' resolved to null.");
            }
            this.setter.invoke(model, serviceInstance);
        }
    }
}

