/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.factory;

import io.neba.api.spi.ResourceModelFactory;
import io.neba.core.resourcemodels.factory.ModelFactory;
import io.neba.core.util.BundleUtil;
import java.util.Hashtable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class NebaPackagesResourceModelFactoryInjector {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private BundleTracker<ServiceRegistration<?>> tracker;

    @Activate
    protected void activate(ComponentContext context) {
        this.tracker = new BundleTracker(context.getBundleContext(), 32, new BundleTrackerCustomizer<ServiceRegistration<?>>(){

            public ServiceRegistration<?> addingBundle(Bundle bundle, BundleEvent event) {
                ModelFactory factory = new ModelFactory(bundle);
                if (factory.getModelDefinitions().isEmpty()) {
                    return null;
                }
                BundleContext bundleContext = bundle.getBundleContext();
                if (bundleContext == null) {
                    NebaPackagesResourceModelFactoryInjector.this.logger.warn("Unable to register the resource models of bundle " + BundleUtil.displayNameOf(bundle) + ", the bundle context is null. This usually means the bundle activator or blueprint context failed to start.");
                    return null;
                }
                Hashtable<String, String> properties = new Hashtable<String, String>();
                properties.put("service.description", "Provides NEBA resource model POJOs from packages specified in the 'Neba-Packages' bundle header.");
                properties.put("service.vendor", "neba.io");
                return bundleContext.registerService(ResourceModelFactory.class, (Object)factory, properties);
            }

            public void modifiedBundle(Bundle bundle, BundleEvent event, ServiceRegistration<?> registration) {
            }

            public void removedBundle(Bundle bundle, BundleEvent event, ServiceRegistration<?> registration) {
                if (registration == null) {
                    return;
                }
                registration.unregister();
            }
        });
        this.tracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this.tracker.close();
    }
}

