/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.factory;

import io.neba.api.annotations.Filter;
import io.neba.core.resourcemodels.factory.InvalidModelException;
import io.neba.core.resourcemodels.factory.ModelInstantiationException;
import io.neba.core.util.ReflectionUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

class ServiceDependency {
    private final Class<?> serviceType;
    private final Filter filter;
    private final boolean hasFilter;
    private final boolean isOptional;
    private final boolean isList;

    ServiceDependency(@Nonnull Type serviceType, @Nonnull Class<?> modelType, @Nullable Filter filter) {
        Class actualServiceType;
        Class rawType = TypeUtils.getRawType((Type)serviceType, modelType);
        if (rawType == null) {
            throw new InvalidModelException("Unable to resolve the service dependency from  '" + modelType + "' to '" + serviceType + "', resolving the raw class of '" + serviceType + "' returned null.");
        }
        if (rawType.isAssignableFrom(List.class)) {
            actualServiceType = TypeUtils.getRawType((Type)this.getLowerBoundOfSingleTypeParameterOrFail(serviceType), modelType);
            this.isList = true;
            this.isOptional = false;
        } else if (serviceType instanceof ParameterizedType && rawType == Optional.class) {
            actualServiceType = TypeUtils.getRawType((Type)this.getLowerBoundOfSingleTypeParameterOrFail(serviceType), modelType);
            this.isOptional = true;
            this.isList = false;
        } else {
            actualServiceType = rawType;
            this.isOptional = false;
            this.isList = false;
        }
        if (actualServiceType == null) {
            throw new InvalidModelException("Unable to resolve the service dependency from  '" + modelType + "' to '" + serviceType + "', resolving the raw class of the service type returned null.");
        }
        if (filter != null && StringUtils.isNotBlank((CharSequence)filter.value())) {
            try {
                FrameworkUtil.createFilter((String)filter.value());
            }
            catch (InvalidSyntaxException e) {
                throw new InvalidModelException("The syntax of the filter '" + filter.value() + "' for the service dependency '" + serviceType + "' of the model '" + modelType + "' is invalid", e);
            }
            this.hasFilter = true;
        } else {
            this.hasFilter = false;
        }
        this.filter = filter;
        this.serviceType = actualServiceType;
    }

    @Nullable
    public Object resolve(@Nonnull BundleContext context) {
        Object resolved = null;
        if (this.hasFilter || this.isList) {
            Collection serviceReferences;
            try {
                serviceReferences = context.getServiceReferences(this.serviceType, this.hasFilter ? this.filter.value() : null);
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalStateException("Unable to retrieve service references of type '" + this.serviceType + "'.", e);
            }
            if (this.isList) {
                ArrayList<Object> serviceInstances = new ArrayList<Object>(serviceReferences.size());
                for (ServiceReference reference : serviceReferences) {
                    Object serviceInstance = context.getService(reference);
                    if (serviceInstance == null) continue;
                    serviceInstances.add(serviceInstance);
                }
                return serviceInstances;
            }
            if (serviceReferences.size() > 1) {
                throw new ModelInstantiationException("Unable to resolve the service dependency " + this + ", got more than one matching service instance: " + serviceReferences + ".");
            }
            if (!serviceReferences.isEmpty()) {
                resolved = context.getService((ServiceReference)serviceReferences.iterator().next());
            }
        } else {
            ServiceReference reference = context.getServiceReference(this.serviceType);
            if (reference != null) {
                resolved = context.getService(reference);
            }
        }
        return this.isOptional ? Optional.ofNullable(resolved) : resolved;
    }

    public String toString() {
        return "ServiceDependency{serviceType=" + this.serviceType + ", filter=" + this.filter + '}';
    }

    private Type getLowerBoundOfSingleTypeParameterOrFail(@Nonnull Type serviceType) {
        try {
            return ReflectionUtil.getLowerBoundOfSingleTypeParameter(serviceType);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidModelException("Unable to resolve the type parameter of " + serviceType + ".", e);
        }
    }
}

