/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.mapping;

import io.neba.api.spi.AnnotatedFieldMapper;
import io.neba.core.resourcemodels.metadata.MappedFieldMetaData;
import io.neba.core.util.ConcurrentDistinctMultiValueMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.ClassUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={AnnotatedFieldMappers.class})
public class AnnotatedFieldMappers {
    private static final Collection<AnnotationMapping> EMPTY = Collections.emptyList();
    private final ConcurrentDistinctMultiValueMap<Field, AnnotationMapping> cache = new ConcurrentDistinctMultiValueMap();
    private final ConcurrentDistinctMultiValueMap<Class<? extends Annotation>, AnnotatedFieldMapper> fieldMappers = new ConcurrentDistinctMultiValueMap();
    private final AtomicInteger state = new AtomicInteger(0);

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unbind")
    protected synchronized void bind(AnnotatedFieldMapper<?, ?> mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException("Method argument mapper must not be null.");
        }
        this.state.getAndIncrement();
        this.fieldMappers.put((Class<? extends Annotation>)mapper.getAnnotationType(), mapper);
        this.cache.clear();
    }

    protected synchronized void unbind(AnnotatedFieldMapper<?, ?> mapper) {
        if (mapper == null) {
            return;
        }
        this.state.getAndIncrement();
        this.fieldMappers.removeValue(mapper);
        this.cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<AnnotationMapping> get(MappedFieldMetaData metaData) {
        if (metaData == null) {
            throw new IllegalArgumentException("Method argument metaData must not be null.");
        }
        Collection<AnnotationMapping> mappers = this.cache.get(metaData.getField());
        if (mappers != null) {
            return mappers;
        }
        int ticket = this.state.get();
        ArrayList<AnnotationMapping> compatibleMappers = new ArrayList<AnnotationMapping>();
        for (Annotation annotation : metaData.getAnnotations()) {
            Collection<AnnotatedFieldMapper> mappersForAnnotation = this.fieldMappers.get(annotation.annotationType());
            if (mappersForAnnotation == null) continue;
            for (AnnotatedFieldMapper mapper : mappersForAnnotation) {
                Class type = ClassUtils.primitiveToWrapper(metaData.getType());
                if (!mapper.getFieldType().isAssignableFrom(type)) continue;
                compatibleMappers.add(new AnnotationMapping(annotation, mapper));
            }
        }
        mappers = compatibleMappers.isEmpty() ? EMPTY : compatibleMappers;
        AnnotatedFieldMappers annotatedFieldMappers = this;
        synchronized (annotatedFieldMappers) {
            if (ticket == this.state.get()) {
                this.cache.put(metaData.getField(), mappers);
            }
        }
        return mappers;
    }

    public static class AnnotationMapping {
        private final Annotation annotation;
        private final AnnotatedFieldMapper mapper;

        AnnotationMapping(Annotation annotation, AnnotatedFieldMapper mapper) {
            this.annotation = annotation;
            this.mapper = mapper;
        }

        public Annotation getAnnotation() {
            return this.annotation;
        }

        public AnnotatedFieldMapper getMapper() {
            return this.mapper;
        }
    }
}

