/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.mapping;

import io.neba.api.resourcemodels.Lazy;
import io.neba.api.spi.AnnotatedFieldMapper;
import io.neba.api.spi.ResourceModelFactory;
import io.neba.core.resourcemodels.mapping.AnnotatedFieldMappers;
import io.neba.core.resourcemodels.mapping.PlaceholderVariableResolvers;
import io.neba.core.resourcemodels.metadata.MappedFieldMetaData;
import io.neba.core.util.PrimitiveSupportingValueMap;
import io.neba.core.util.ReflectionUtil;
import io.neba.core.util.ResourcePaths;
import io.neba.core.util.StringUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.LazyLoader;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class FieldValueMappingCallback {
    private final Object model;
    private final ValueMap properties;
    private final Resource resource;
    private final AnnotatedFieldMappers annotatedFieldMappers;
    private final PlaceholderVariableResolvers placeholderVariableResolvers;

    FieldValueMappingCallback(Object model, Resource resource, ResourceModelFactory factory, AnnotatedFieldMappers mappers, PlaceholderVariableResolvers resolvers) {
        if (model == null) {
            throw new IllegalArgumentException("Constructor parameter model must not be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("Constructor parameter resource must not be null.");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Constructor parameter factory must not be null.");
        }
        if (mappers == null) {
            throw new IllegalArgumentException("Method argument mappers must not be null.");
        }
        if (resolvers == null) {
            throw new IllegalArgumentException("Method argument resolvers must not be null");
        }
        this.model = model;
        this.properties = FieldValueMappingCallback.toValueMap(resource);
        this.resource = resource;
        this.annotatedFieldMappers = mappers;
        this.placeholderVariableResolvers = resolvers;
    }

    final void doWith(MappedFieldMetaData metaData) {
        if (metaData == null) {
            throw new IllegalArgumentException("Method argument metaData must not be null.");
        }
        FieldData fieldData = new FieldData(metaData, this.evaluateFieldPath(metaData));
        boolean isMappable = this.isMappable(fieldData);
        if (metaData.isLazy()) {
            Lazy lazy = isMappable ? new LazyFieldValue(fieldData, this) : Optional::empty;
            this.setField(metaData, lazy);
            return;
        }
        Object value = null;
        if (isMappable) {
            value = this.resolve(fieldData);
        }
        if ((value = this.postProcessResolvedValue(fieldData, value)) != null) {
            this.setField(metaData, value);
        }
    }

    private Object resumeMapping(FieldData fieldData) {
        return this.postProcessResolvedValue(fieldData, this.resolve(fieldData));
    }

    private Object postProcessResolvedValue(FieldData fieldData, Object value) {
        boolean preventNullCollection = value == null && !fieldData.metaData.isLazy() && fieldData.metaData.isInstantiableCollectionType() && this.getField(fieldData) == null;
        Collection defaultValue = preventNullCollection ? ReflectionUtil.instantiateCollectionType(fieldData.metaData.getType()) : null;
        value = this.applyCustomMappings(fieldData, value == null ? defaultValue : value);
        return value == null ? defaultValue : value;
    }

    private Object applyCustomMappings(FieldData fieldData, Object value) {
        Object result = value;
        for (AnnotatedFieldMappers.AnnotationMapping mapping : this.annotatedFieldMappers.get(fieldData.metaData)) {
            result = mapping.getMapper().map((AnnotatedFieldMapper.OngoingMapping)new OngoingFieldMapping(this.model, result, mapping, fieldData, this.resource, this.properties));
        }
        return result;
    }

    private Object resolve(FieldData fieldData) {
        Object value = fieldData.metaData.isThisReference() ? this.convertThisResourceToFieldType(fieldData) : (fieldData.metaData.isChildrenAnnotationPresent() ? this.resolveChildren(fieldData) : (fieldData.metaData.isReference() ? this.resolveReferenceValueOfField(fieldData) : (fieldData.metaData.isPropertyType() ? this.resolvePropertyTypedValue(fieldData) : this.resolveResource(fieldData.path, fieldData.metaData.getType()))));
        return value;
    }

    private Object convertThisResourceToFieldType(FieldData field) {
        return FieldValueMappingCallback.convert(this.resource, field.metaData.getType());
    }

    private Collection<?> resolveChildren(FieldData field) {
        if (field.metaData.isLazy()) {
            return this.loadChildren(field);
        }
        return (Collection)field.metaData.getCollectionProxyFactory().newInstance((Callback)new LazyChildrenLoader(field, this));
    }

    private Collection<Object> loadChildren(FieldData field) {
        Class<?> collectionType = field.metaData.getType();
        Collection<Object> values = ReflectionUtil.instantiateCollectionType(collectionType);
        Resource parent = null;
        if (field.metaData.isReference()) {
            String referencedPath = this.resolvePropertyTypedValue(field, String.class);
            if (!StringUtils.isBlank((CharSequence)referencedPath)) {
                parent = this.resolveResource(referencedPath, Resource.class);
            }
        } else {
            parent = field.metaData.isPathAnnotationPresent() ? this.resolveResource(field.path, Resource.class) : this.resource;
        }
        if (parent == null) {
            return values;
        }
        Class<?> targetType = field.metaData.getTypeParameter();
        Iterator children = parent.listChildren();
        while (children.hasNext()) {
            Object adapted;
            Resource child = (Resource)children.next();
            if (field.metaData.isResolveBelowEveryChildPathPresentOnChildren() && (child = child.getChild(field.metaData.getResolveBelowEveryChildPathOnChildren())) == null || (adapted = FieldValueMappingCallback.convert(child, targetType)) == null) continue;
            values.add(adapted);
        }
        return values;
    }

    private Object resolveReferenceValueOfField(FieldData field) {
        Collection<Object> value = null;
        if (field.metaData.isCollectionType()) {
            String[] referencedResourcePaths = this.resolvePropertyTypedValue(field, String[].class);
            if (referencedResourcePaths != null) {
                value = this.createCollectionOfReferences(field, referencedResourcePaths);
            }
        } else {
            String referencedResourcePath = this.resolvePropertyTypedValue(field, String.class);
            if (referencedResourcePath != null) {
                if (field.metaData.isAppendPathPresentOnReference()) {
                    referencedResourcePath = referencedResourcePath + field.metaData.getAppendPathOnReference();
                }
                value = this.resolveResource(referencedResourcePath, field.metaData.getType());
            }
        }
        return value;
    }

    private Collection<Object> createCollectionOfReferences(FieldData field, String[] paths) {
        if (field.metaData.isLazy()) {
            return this.loadReferences(field, paths);
        }
        Collection result = (Collection)field.metaData.getCollectionProxyFactory().newInstance((Callback)new LazyReferencesLoader(field, paths, this));
        return result;
    }

    private Collection<Object> loadReferences(FieldData field, String[] paths) {
        Class<?> collectionType = field.metaData.getType();
        Collection<Object> values = ReflectionUtil.instantiateCollectionType(collectionType, paths.length);
        String[] resourcePaths = paths;
        if (field.metaData.isAppendPathPresentOnReference()) {
            resourcePaths = StringUtil.appendToAll(field.metaData.getAppendPathOnReference(), paths);
        }
        Class<?> componentClass = field.metaData.getTypeParameter();
        for (String path : resourcePaths) {
            Object element = this.resolveResource(path, componentClass);
            if (element == null) continue;
            values.add(element);
        }
        return values;
    }

    private Object resolvePropertyTypedValue(FieldData field) {
        Collection<?> value = field.metaData.isInstantiableCollectionType() ? this.getArrayPropertyAsCollection(field) : this.resolvePropertyTypedValue(field, field.metaData.getType());
        return value;
    }

    private <T> T resolvePropertyTypedValue(FieldData field, Class<T> propertyType) {
        if (field.isAbsolute() || field.isRelative()) {
            return this.resolvePropertyTypedValueFromForeignResource(field, propertyType);
        }
        if (this.properties == null) {
            throw new IllegalStateException("Tried to map the property " + field + " even though the resource has no properties.");
        }
        return (T)this.properties.get(field.path, propertyType);
    }

    private <T> T resolveResource(String resourcePath, Class<T> targetType) {
        Resource absoluteResource = this.resource.getResourceResolver().getResource(this.resource, resourcePath);
        return FieldValueMappingCallback.convert(absoluteResource, targetType);
    }

    private <T> T resolvePropertyTypedValueFromForeignResource(FieldData field, Class<T> propertyType) {
        Resource property = this.resource.getResourceResolver().getResource(this.resource, field.path);
        if (property == null) {
            return null;
        }
        if (propertyType == String.class || propertyType == String[].class) {
            return (T)property.adaptTo(propertyType);
        }
        Resource parent = property.getParent();
        if (parent == null) {
            return null;
        }
        ValueMap properties = (ValueMap)parent.adaptTo(ValueMap.class);
        if (properties == null) {
            return null;
        }
        return (T)new PrimitiveSupportingValueMap(properties).get(property.getName(), propertyType);
    }

    private Collection<?> getArrayPropertyAsCollection(FieldData field) {
        Class<?> arrayType = field.metaData.getArrayTypeOfTypeParameter();
        Object[] elements = (Object[])this.resolvePropertyTypedValue(field, arrayType);
        if (elements != null) {
            Collection collection = ReflectionUtil.instantiateCollectionType(field.metaData.getType());
            Collections.addAll(collection, elements);
            return collection;
        }
        return null;
    }

    private String evaluateFieldPath(MappedFieldMetaData fieldMetaData) {
        ResourcePaths.ResourcePath path = fieldMetaData.getPath();
        return (path.hasPlaceholders() ? path.resolve(this.placeholderVariableResolvers::resolve) : path).getPath();
    }

    private boolean isMappable(FieldData field) {
        return this.properties != null || field.metaData.isThisReference() || field.isReferenceToOtherResource();
    }

    private static ValueMap toValueMap(Resource resource) {
        ValueMap propertyMap = (ValueMap)resource.adaptTo(ValueMap.class);
        if (propertyMap != null) {
            propertyMap = new PrimitiveSupportingValueMap(propertyMap);
        }
        return propertyMap;
    }

    private Object getField(FieldData fieldData) {
        try {
            return fieldData.metaData.getField().get(this.model);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private void setField(MappedFieldMetaData metaData, Object value) {
        try {
            metaData.getField().set(this.model, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private static <T> T convert(Resource resource, Class<T> targetType) {
        if (resource == null) {
            return null;
        }
        if (targetType.isAssignableFrom(resource.getClass())) {
            return (T)resource;
        }
        return (T)resource.adaptTo(targetType);
    }

    private static class OngoingFieldMapping
    implements AnnotatedFieldMapper.OngoingMapping {
        private final Object resolvedValue;
        private final AnnotatedFieldMappers.AnnotationMapping mapping;
        private final FieldData fieldData;
        private final Object model;
        private final Resource resource;
        private final ValueMap properties;
        private final MappedFieldMetaData metaData;

        OngoingFieldMapping(Object model, Object resolvedValue, AnnotatedFieldMappers.AnnotationMapping mapping, FieldData fieldData, Resource resource, ValueMap properties) {
            this.model = model;
            this.resolvedValue = resolvedValue;
            this.mapping = mapping;
            this.metaData = fieldData.metaData;
            this.fieldData = fieldData;
            this.resource = resource;
            this.properties = properties;
        }

        @CheckForNull
        public Object getResolvedValue() {
            return this.resolvedValue;
        }

        @Nonnull
        public Object getAnnotation() {
            return this.mapping.getAnnotation();
        }

        @Nonnull
        public Object getModel() {
            return this.model;
        }

        @Nonnull
        public Field getField() {
            return this.metaData.getField();
        }

        @Nonnull
        public Map<Class<? extends Annotation>, Annotation> getAnnotationsOfField() {
            return this.metaData.getAnnotations().getAnnotations();
        }

        @Nonnull
        public Class<?> getFieldType() {
            return this.metaData.getType();
        }

        @CheckForNull
        public Class<?> getFieldTypeParameter() {
            return this.metaData.getTypeParameter();
        }

        @Nonnull
        public String getRepositoryPath() {
            return this.fieldData.path;
        }

        @Nonnull
        public Resource getResource() {
            return this.resource;
        }

        @Nonnull
        public ValueMap getProperties() {
            return this.properties;
        }
    }

    private static class LazyReferencesLoader
    implements LazyLoader {
        private final FieldData field;
        private final String[] paths;
        private final FieldValueMappingCallback callback;

        LazyReferencesLoader(FieldData field, String[] paths, FieldValueMappingCallback callback) {
            this.field = field;
            this.paths = paths;
            this.callback = callback;
        }

        public Object loadObject() {
            return this.callback.loadReferences(this.field, this.paths);
        }
    }

    private static class LazyChildrenLoader
    implements LazyLoader {
        private final FieldData field;
        private final FieldValueMappingCallback mapper;

        LazyChildrenLoader(FieldData field, FieldValueMappingCallback callback) {
            this.field = field;
            this.mapper = callback;
        }

        public Object loadObject() {
            return this.mapper.loadChildren(this.field);
        }
    }

    private static class LazyFieldValue
    implements Lazy<Object> {
        private static final Object NULL = new Object();
        private final FieldData fieldData;
        private final FieldValueMappingCallback callback;
        private Object value = NULL;

        LazyFieldValue(FieldData fieldData, FieldValueMappingCallback callback) {
            this.fieldData = fieldData;
            this.callback = callback;
        }

        @Nonnull
        public Optional<Object> asOptional() {
            if (this.value == NULL) {
                this.load();
            }
            return Optional.ofNullable(this.value);
        }

        private synchronized void load() {
            if (this.value == NULL) {
                this.value = this.callback.resumeMapping(this.fieldData);
            }
        }
    }

    private static final class FieldData {
        private final MappedFieldMetaData metaData;
        private final String path;
        private final boolean isAbsolute;
        private final boolean isRelative;

        private FieldData(MappedFieldMetaData metaData, String path) {
            this.metaData = metaData;
            this.path = path;
            this.isAbsolute = !path.isEmpty() && path.charAt(0) == '/';
            this.isRelative = !this.isAbsolute && path.indexOf(47) != -1;
        }

        private boolean isAbsolute() {
            return this.isAbsolute;
        }

        private boolean isRelative() {
            return this.isRelative;
        }

        private boolean isReferenceToOtherResource() {
            return !this.metaData.isPropertyType() || this.isAbsolute() || this.isRelative();
        }
    }
}

