/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.mapping;

import io.neba.core.resourcemodels.metadata.ResourceModelMetaData;
import io.neba.core.util.Key;

public class Mapping<T>
extends Key {
    private final String srcPath;
    private final ResourceModelMetaData metadata;
    private T mappedModel = null;

    Mapping(String resourcePath, ResourceModelMetaData metadata) {
        super(resourcePath, metadata);
        if (resourcePath == null) {
            throw new IllegalArgumentException("Method argument resourcePath must not be null.");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("Method argument metadata must not be null.");
        }
        this.srcPath = resourcePath;
        this.metadata = metadata;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.srcPath + " -> " + this.metadata.getTypeName() + ']';
    }

    void setMappedModel(T mappedModel) {
        this.mappedModel = mappedModel;
    }

    T getMappedModel() {
        return this.mappedModel;
    }

    public ResourceModelMetaData getMetadata() {
        return this.metadata;
    }
}

