/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.mapping;

import io.neba.api.annotations.AfterMapping;
import io.neba.core.resourcemodels.metadata.MethodMetaData;
import io.neba.core.resourcemodels.metadata.ResourceModelMetaData;
import io.neba.core.util.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ModelProcessor.class})
public class ModelProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    <T> void processAfterMapping(ResourceModelMetaData metaData, T model) {
        if (metaData == null) {
            throw new IllegalArgumentException("Method argument metaData must not be null.");
        }
        if (model == null) {
            throw new IllegalArgumentException("Method argument model must not be null.");
        }
        for (MethodMetaData methodMetaData : metaData.getAfterMappingMethods()) {
            Method method = methodMetaData.getMethod();
            ReflectionUtil.makeAccessible(method);
            try {
                method.invoke(model, new Object[0]);
            }
            catch (SecurityException | InvocationTargetException e) {
                this.logger.error("Unable to invoke the @" + AfterMapping.class.getSimpleName() + " method " + method + ".", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("It must not be illegal to access " + method + ".", e);
            }
        }
    }
}

