/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.mapping;

import io.neba.core.resourcemodels.mapping.Mapping;
import io.neba.core.resourcemodels.metadata.ResourceModelMetaData;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;

@Component(service={NestedMappingSupport.class})
public class NestedMappingSupport {
    private final ThreadLocal<OngoingMappings> ongoingMappings = new ThreadLocal();

    <T> Mapping<T> begin(Mapping<T> mapping) {
        if (mapping == null) {
            throw new IllegalArgumentException("Method argument mapping must not be null");
        }
        OngoingMappings ongoingMappings = this.getOrCreateMappings();
        Mapping<T> alreadyExistingMapping = ongoingMappings.get(mapping);
        if (alreadyExistingMapping == null) {
            this.trackNestedMapping(ongoingMappings);
            ongoingMappings.add(mapping);
        }
        return alreadyExistingMapping;
    }

    public void end(Mapping mapping) {
        if (mapping == null) {
            throw new IllegalArgumentException("Method argument mapping must not be null");
        }
        OngoingMappings ongoingMappings = this.ongoingMappings.get();
        if (ongoingMappings != null) {
            ongoingMappings.remove(mapping);
            if (ongoingMappings.isEmpty()) {
                this.ongoingMappings.remove();
            }
        }
    }

    private OngoingMappings getOrCreateMappings() {
        OngoingMappings ongoingMappings = this.ongoingMappings.get();
        if (ongoingMappings == null) {
            ongoingMappings = new OngoingMappings();
            this.ongoingMappings.set(ongoingMappings);
        }
        return ongoingMappings;
    }

    private void trackNestedMapping(OngoingMappings ongoingMappings) {
        for (ResourceModelMetaData metaData : ongoingMappings.getMetaData()) {
            metaData.getStatistics().countSubsequentMapping();
        }
    }

    Set<Mapping> getOngoingMappings() {
        return this.getOrCreateMappings().getMappings();
    }

    boolean hasOngoingMapping(ResourceModelMetaData metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("Method argument metadata must not be null");
        }
        return this.getOrCreateMappings().contains(metadata);
    }

    private static class OngoingMappings {
        private final Map<Mapping, Mapping> mappings = new LinkedHashMap<Mapping, Mapping>();
        private final Map<ResourceModelMetaData, Count> metaData = new HashMap<ResourceModelMetaData, Count>();

        private OngoingMappings() {
        }

        public void add(Mapping<?> mapping) {
            this.mappings.put(mapping, mapping);
            Count value = new Count();
            Count previous = this.metaData.put(mapping.getMetadata(), value);
            if (previous != null) {
                value.add(previous);
            }
        }

        public void remove(Mapping<?> mapping) {
            this.mappings.remove(mapping);
            Count count = this.metaData.get(mapping.getMetadata());
            if (count != null && count.decrement() == 0) {
                this.metaData.remove(mapping.getMetadata());
            }
        }

        public <T> Mapping<T> get(Mapping<T> mapping) {
            return this.mappings.get(mapping);
        }

        public boolean contains(ResourceModelMetaData metaData) {
            return this.metaData.containsKey(metaData);
        }

        public boolean isEmpty() {
            return this.mappings.isEmpty();
        }

        public Set<Mapping> getMappings() {
            return this.mappings.keySet();
        }

        public Set<ResourceModelMetaData> getMetaData() {
            return this.metaData.keySet();
        }

        private static class Count {
            private int i = 1;

            private Count() {
            }

            public void add(Count other) {
                this.i += other.i;
            }

            int decrement() {
                --this.i;
                return this.i;
            }
        }
    }
}

