/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.mapping;

import io.neba.api.spi.PlaceholderVariableResolver;
import java.util.ArrayList;
import java.util.Collection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={PlaceholderVariableResolvers.class})
public class PlaceholderVariableResolvers {
    private final Collection<PlaceholderVariableResolver> resolvers = new ArrayList<PlaceholderVariableResolver>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unbind")
    protected void bind(PlaceholderVariableResolver resolver) {
        this.resolvers.add(resolver);
    }

    protected void unbind(PlaceholderVariableResolver resolver) {
        if (resolver == null) {
            return;
        }
        this.resolvers.remove(resolver);
    }

    String resolve(String variableName) {
        if (variableName == null) {
            throw new IllegalArgumentException("Method argument variableName must not be null");
        }
        for (PlaceholderVariableResolver resolver : this.resolvers) {
            String resolved = resolver.resolve(variableName);
            if (resolved == null) continue;
            return resolved;
        }
        String resolved = System.getenv(variableName);
        if (resolved != null) {
            return resolved;
        }
        return System.getProperty(variableName, null);
    }
}

