/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.mapping;

import io.neba.api.spi.AopSupport;
import io.neba.api.spi.ResourceModelFactory;
import io.neba.api.spi.ResourceModelPostProcessor;
import io.neba.core.resourcemodels.mapping.AnnotatedFieldMappers;
import io.neba.core.resourcemodels.mapping.CycleInModelInitializationException;
import io.neba.core.resourcemodels.mapping.FieldValueMappingCallback;
import io.neba.core.resourcemodels.mapping.Mapping;
import io.neba.core.resourcemodels.mapping.ModelProcessor;
import io.neba.core.resourcemodels.mapping.NestedMappingSupport;
import io.neba.core.resourcemodels.mapping.PlaceholderVariableResolvers;
import io.neba.core.resourcemodels.metadata.MappedFieldMetaData;
import io.neba.core.resourcemodels.metadata.ResourceModelMetaData;
import io.neba.core.resourcemodels.metadata.ResourceModelMetaDataRegistrar;
import io.neba.core.util.OsgiModelSource;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={ResourceToModelMapper.class})
public class ResourceToModelMapper {
    private final List<ResourceModelPostProcessor> postProcessors = new ArrayList<ResourceModelPostProcessor>();
    private final List<AopSupport> aopSupports = new ArrayList<AopSupport>();
    @Reference
    private ModelProcessor modelProcessor;
    @Reference
    private NestedMappingSupport nestedMappingSupport;
    @Reference
    private AnnotatedFieldMappers fieldMappers;
    @Reference
    private PlaceholderVariableResolvers variableResolvers;
    @Reference
    private ResourceModelMetaDataRegistrar resourceModelMetaDataRegistrar;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T map(Resource resource, OsgiModelSource<T> modelSource) {
        Object model;
        if (resource == null) {
            throw new IllegalArgumentException("Method argument resource must not be null");
        }
        if (modelSource == null) {
            throw new IllegalArgumentException("Method argument modelSource must not be null");
        }
        Class<?> modelType = modelSource.getModelType();
        ResourceModelMetaData metaData = this.resourceModelMetaDataRegistrar.get(modelType);
        Mapping<T> mapping = new Mapping<T>(resource.getPath(), metaData);
        boolean trackMappingDuration = !this.nestedMappingSupport.hasOngoingMapping(metaData);
        Mapping alreadyOngoingMapping = this.nestedMappingSupport.begin(mapping);
        if (alreadyOngoingMapping == null) {
            try {
                T mappedModel = modelSource.getModel();
                metaData.getStatistics().countInstantiation();
                mapping.setMappedModel(mappedModel);
                long startTimeInMs = trackMappingDuration ? System.currentTimeMillis() : 0L;
                model = this.map(resource, mappedModel, metaData, modelSource.getFactory());
                if (!trackMappingDuration) return model;
                metaData.getStatistics().countMappingDuration((int)(System.currentTimeMillis() - startTimeInMs));
                return model;
            }
            finally {
                this.nestedMappingSupport.end(mapping);
            }
        } else {
            model = alreadyOngoingMapping.getMappedModel();
            if (model != null) return model;
            throw new CycleInModelInitializationException("Unable to provide model " + modelType + " for resource " + resource + ". The model initialization resulted in a cycle: " + StringUtils.join(this.nestedMappingSupport.getOngoingMappings(), (String)" >> ") + " >> " + mapping + ". Does the model depend on itself to initialize, e.g. in a @PostConstruct method?");
        }
    }

    private <T> T map(Resource resource, T model, ResourceModelMetaData metaData, ResourceModelFactory factory) {
        T fieldInjectionViewOnPreprocessedModel = this.prepareAopEnhancedModelTypes(model);
        FieldValueMappingCallback callback = new FieldValueMappingCallback(fieldInjectionViewOnPreprocessedModel, resource, factory, this.fieldMappers, this.variableResolvers);
        for (MappedFieldMetaData mappedFieldMetaData : metaData.getMappableFields()) {
            callback.doWith(mappedFieldMetaData);
        }
        return this.postProcess(resource, model, factory);
    }

    private <T> T prepareAopEnhancedModelTypes(T preprocessedModel) {
        Object model = preprocessedModel;
        for (AopSupport aopSupport : this.aopSupports) {
            model = aopSupport.prepareForFieldInjection(model);
        }
        return model;
    }

    private <T> T postProcess(Resource resource, T model, ResourceModelFactory factory) {
        ResourceModelMetaData metaData = this.resourceModelMetaDataRegistrar.get(model.getClass());
        this.modelProcessor.processAfterMapping(metaData, model);
        Object currentModel = model;
        for (ResourceModelPostProcessor processor : this.postProcessors) {
            Object processedModel = processor.processAfterMapping(currentModel, resource, factory);
            if (processedModel == null) continue;
            currentModel = processedModel;
        }
        return currentModel;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unbindProcessor")
    protected void bindProcessor(ResourceModelPostProcessor postProcessor) {
        this.postProcessors.add(postProcessor);
    }

    protected void unbindProcessor(ResourceModelPostProcessor postProcessor) {
        if (postProcessor == null) {
            return;
        }
        this.postProcessors.remove(postProcessor);
    }

    protected void bindAopSupport(AopSupport aopSupport) {
        this.aopSupports.add(aopSupport);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unbindAopSupport")
    protected void unbindAopSupport(AopSupport support) {
        if (support == null) {
            return;
        }
        this.aopSupports.remove(support);
    }
}

