/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.metadata;

import io.neba.api.annotations.Children;
import io.neba.api.annotations.Path;
import io.neba.api.annotations.Reference;
import io.neba.api.annotations.This;
import io.neba.api.resourcemodels.Lazy;
import io.neba.core.util.Annotations;
import io.neba.core.util.ReflectionUtil;
import io.neba.core.util.ResourcePaths;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.LazyLoader;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.TypeUtils;

public class MappedFieldMetaData {
    private boolean isLazy;
    private final Field field;
    private final Annotations annotations;
    private final ResourcePaths.ResourcePath path;
    private final boolean isReference;
    private final boolean isAppendPathPresentOnReference;
    private final String appendPathOnReference;
    private final boolean isThisReference;
    private final boolean isPathAnnotationPresent;
    private final boolean isPropertyType;
    private final boolean isCollectionType;
    private final boolean isInstantiableCollectionType;
    private final boolean isChildrenAnnotationPresent;
    private final boolean isResolveBelowEveryChildPathPresentOnChildren;
    private final String resolveBelowEveryChildPathOnChildren;
    private final Class<?> typeParameter;
    private final Class<?> arrayTypeOfComponentType;
    private final Type genericFieldType;
    private final Class<?> fieldType;
    private final Class<?> modelType;
    private final Factory collectionProxyFactory;

    private static boolean isPropertyType(Class<?> type) {
        return type.isPrimitive() || type == String.class || type == Date.class || type == Calendar.class || ClassUtils.wrapperToPrimitive(type) != null;
    }

    public MappedFieldMetaData(Field field, Class<?> modelType) {
        if (field == null) {
            throw new IllegalArgumentException("Constructor parameter field must not be null.");
        }
        if (modelType == null) {
            throw new IllegalArgumentException("Method argument modelType must not be null.");
        }
        this.modelType = modelType;
        this.field = field;
        this.isLazy = field.getType() == Lazy.class;
        this.annotations = Annotations.annotations(field);
        this.genericFieldType = this.isLazy ? this.getParameterTypeOf(field.getGenericType()) : field.getGenericType();
        this.fieldType = this.isLazy ? TypeUtils.getRawType((Type)this.genericFieldType, this.modelType) : field.getType();
        this.isCollectionType = Collection.class.isAssignableFrom(this.fieldType);
        this.isPathAnnotationPresent = this.annotations.contains(Path.class);
        this.isReference = this.annotations.contains(Reference.class);
        this.isThisReference = this.annotations.contains(This.class);
        this.isChildrenAnnotationPresent = this.annotations.contains(Children.class);
        this.isAppendPathPresentOnReference = this.isAppendPathPresentOnReferenceInternal();
        this.appendPathOnReference = this.getAppendPathFromReference();
        this.isResolveBelowEveryChildPathPresentOnChildren = this.isResolveBelowEveryChildPathPresentOnChildrenInternal();
        this.resolveBelowEveryChildPathOnChildren = this.getResolveBelowEveryChildPathFromChildren();
        this.typeParameter = this.resolveTypeParameter();
        this.arrayTypeOfComponentType = this.resolveArrayTypeOfComponentType();
        this.path = this.getPathInternal();
        this.isPropertyType = this.isPropertyTypeInternal();
        this.isInstantiableCollectionType = ReflectionUtil.isInstantiableCollectionType(this.fieldType);
        this.enforceInstantiableCollectionTypeForExplicitlyMappedFields();
        this.collectionProxyFactory = this.prepareProxyFactoryForCollectionTypes();
        ReflectionUtil.makeAccessible(field);
    }

    private Type getParameterTypeOf(Type type) {
        try {
            return ReflectionUtil.getLowerBoundOfSingleTypeParameter(type);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to resolve a generic parameter type of the mapped field " + this.field + ".", e);
        }
    }

    private Factory prepareProxyFactoryForCollectionTypes() {
        if (this.isInstantiableCollectionType) {
            return (Factory)Enhancer.create(this.fieldType, (Callback)((LazyLoader)() -> null));
        }
        return null;
    }

    public Factory getCollectionProxyFactory() {
        return this.collectionProxyFactory;
    }

    private String getAppendPathFromReference() {
        return this.isAppendPathPresentOnReference ? this.getAppendPathOfReference() : null;
    }

    private boolean isAppendPathPresentOnReferenceInternal() {
        return this.isReference && !StringUtils.isBlank((CharSequence)this.getAppendPathOfReference());
    }

    private String getAppendPathOfReference() {
        String path = this.annotations.get(Reference.class).append();
        if (!StringUtils.isEmpty((CharSequence)path) && path.charAt(0) != '/') {
            path = '/' + path;
        }
        return path;
    }

    private boolean isResolveBelowEveryChildPathPresentOnChildrenInternal() {
        return this.isChildrenAnnotationPresent && !StringUtils.isBlank((CharSequence)this.getResolveBelowEveryChildPathOfChildren());
    }

    private String getResolveBelowEveryChildPathFromChildren() {
        return this.isResolveBelowEveryChildPathPresentOnChildren ? this.getResolveBelowEveryChildPathOfChildren() : null;
    }

    private String getResolveBelowEveryChildPathOfChildren() {
        String relativePath = this.annotations.get(Children.class).resolveBelowEveryChild();
        return this.isResolveBelowEveryChildPathPresentOnChildren && relativePath.charAt(0) == '/' ? relativePath.substring(1) : relativePath;
    }

    private Class<?> resolveTypeParameter() {
        Class<?> typeParameter = null;
        if (this.isCollectionType) {
            typeParameter = TypeUtils.getRawType((Type)this.getParameterTypeOf(this.genericFieldType), this.modelType);
        } else if (this.getType().isArray()) {
            typeParameter = this.getType().getComponentType();
        }
        return typeParameter;
    }

    private Class<?> resolveArrayTypeOfComponentType() {
        if (this.typeParameter != null) {
            return Array.newInstance(this.typeParameter, 0).getClass();
        }
        return null;
    }

    private void enforceInstantiableCollectionTypeForExplicitlyMappedFields() {
        if ((this.isReference && this.isCollectionType || this.isChildrenAnnotationPresent) && !this.isInstantiableCollectionType) {
            throw new IllegalArgumentException("Unsupported type of field " + this.field + ": Only " + StringUtils.join((Object[])ReflectionUtil.getInstantiableCollectionTypes(), (String)", ") + " are supported.");
        }
    }

    private ResourcePaths.ResourcePath getPathInternal() {
        String resolvedPath;
        if (this.isPathAnnotationPresent()) {
            Path path = this.annotations.get(Path.class);
            if (StringUtils.isBlank((CharSequence)path.value())) {
                throw new IllegalArgumentException("The value of the @" + Path.class.getSimpleName() + " annotation on " + this.field + " must not be empty");
            }
            resolvedPath = path.value();
        } else {
            resolvedPath = this.field.getName();
        }
        return ResourcePaths.path(resolvedPath);
    }

    private boolean isPropertyTypeInternal() {
        Class<?> type = this.getType();
        return this.isReference() || MappedFieldMetaData.isPropertyType(type) || (type.isArray() || this.isCollectionType) && MappedFieldMetaData.isPropertyType(this.getTypeParameter());
    }

    public Field getField() {
        return this.field;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public boolean isAppendPathPresentOnReference() {
        return this.isAppendPathPresentOnReference;
    }

    public String getAppendPathOnReference() {
        return this.appendPathOnReference;
    }

    public boolean isThisReference() {
        return this.isThisReference;
    }

    public ResourcePaths.ResourcePath getPath() {
        return this.path;
    }

    public Class<?> getType() {
        return this.fieldType;
    }

    public boolean isPathAnnotationPresent() {
        return this.isPathAnnotationPresent;
    }

    public boolean isPropertyType() {
        return this.isPropertyType;
    }

    public boolean isCollectionType() {
        return this.isCollectionType;
    }

    public boolean isInstantiableCollectionType() {
        return this.isInstantiableCollectionType;
    }

    public boolean isChildrenAnnotationPresent() {
        return this.isChildrenAnnotationPresent;
    }

    public boolean isResolveBelowEveryChildPathPresentOnChildren() {
        return this.isResolveBelowEveryChildPathPresentOnChildren;
    }

    public String getResolveBelowEveryChildPathOnChildren() {
        return this.resolveBelowEveryChildPathOnChildren;
    }

    public Class<?> getTypeParameter() {
        return this.typeParameter;
    }

    public Class<?> getArrayTypeOfTypeParameter() {
        return this.arrayTypeOfComponentType;
    }

    public Annotations getAnnotations() {
        return this.annotations;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && ((MappedFieldMetaData)obj).field.equals(this.field);
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.field + "]";
    }
}

