/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.metadata;

import io.neba.api.annotations.AfterMapping;
import io.neba.core.util.Annotations;
import java.lang.reflect.Method;

public class MethodMetaData {
    private final Method method;
    private final boolean isAfterMappingCallback;

    MethodMetaData(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("Constructor parameter method must not be null.");
        }
        this.method = method;
        Annotations element = Annotations.annotations(method);
        this.isAfterMappingCallback = element.contains(AfterMapping.class);
    }

    public Method getMethod() {
        return this.method;
    }

    boolean isAfterMappingCallback() {
        return this.isAfterMappingCallback;
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && ((MethodMetaData)obj).method.equals(this.method);
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.method + "]";
    }
}

