/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.metadata;

import io.neba.core.resourcemodels.metadata.MappedFieldMetaData;
import io.neba.core.resourcemodels.metadata.ResourceModelMetaData;
import io.neba.core.resourcemodels.metadata.ResourceModelMetaDataRegistrar;
import io.neba.core.resourcemodels.metadata.ResourceModelStatistics;
import io.neba.core.util.JsonUtil;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"felix.webconsole.label=modelstatistics", "service.description=Provides a Felix console plugin visualizing resource @ResourceModel statistics.", "service.vendor=neba.io"})
public class ModelStatisticsConsolePlugin
extends AbstractWebConsolePlugin {
    static final String LABEL = "modelstatistics";
    private static final long serialVersionUID = -8676958166611686979L;
    private static final String STATISTICS_API_PATH = "/api/statistics";
    private static final String RESET_API_PATH = "/api/reset";
    @Reference
    private ResourceModelMetaDataRegistrar modelMetaDataRegistrar;

    public String getCategory() {
        return "NEBA";
    }

    public String getLabel() {
        return LABEL;
    }

    public String getTitle() {
        return "Model statistics";
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String suffix = StringUtils.substringAfter((String)req.getRequestURI(), (String)(req.getServletPath() + "/" + this.getLabel()));
        if (!StringUtils.isBlank((CharSequence)suffix) && suffix.startsWith(STATISTICS_API_PATH)) {
            this.setNoCacheHeaders(res);
            this.getModelMetadata(suffix.substring(STATISTICS_API_PATH.length()), res);
            return;
        }
        if (!StringUtils.isBlank((CharSequence)suffix) && suffix.startsWith(RESET_API_PATH)) {
            this.setNoCacheHeaders(res);
            this.resetStatistics(res);
            return;
        }
        super.doGet(req, res);
    }

    private void setNoCacheHeaders(HttpServletResponse res) {
        res.setHeader("Expires", "Sat, 6 May 1970 12:00:00 GMT");
        res.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        res.addHeader("Cache-Control", "post-check=0, pre-check=0");
        res.setHeader("Pragma", "no-cache");
    }

    private void resetStatistics(HttpServletResponse res) throws IOException {
        for (ResourceModelMetaData metaData : this.modelMetaDataRegistrar.get()) {
            metaData.getStatistics().reset();
        }
        this.prepareJsonResponse(res);
        res.getWriter().write("{\"success\": true}");
    }

    private void getModelMetadata(String typePath, HttpServletResponse res) throws IOException {
        if (typePath.isEmpty()) {
            this.provideStatisticsOfAllModels(res);
        } else {
            String typeName = typePath.substring(1);
            this.provideStatisticsOfModel(typeName, res);
        }
    }

    private void provideStatisticsOfModel(String typeName, HttpServletResponse res) throws IOException {
        ResourceModelMetaData metaData = (ResourceModelMetaData)CollectionUtils.find(this.modelMetaDataRegistrar.get(), object -> ((ResourceModelMetaData)object).getTypeName().equals(typeName));
        if (metaData != null) {
            Map<String, Object> data = this.toMap(metaData);
            ResourceModelStatistics statistics = metaData.getStatistics();
            int[] mappingDurationFrequencies = statistics.getMappingDurationFrequencies();
            int[] intervalBoundaries = statistics.getMappingDurationIntervalBoundaries();
            LinkedHashMap<String, Integer> durationFrequencies = new LinkedHashMap<String, Integer>();
            int leftBoundary = 0;
            for (int i = 0; i < mappingDurationFrequencies.length; ++i) {
                durationFrequencies.put("[" + leftBoundary + ", " + intervalBoundaries[i] + ")", mappingDurationFrequencies[i]);
                leftBoundary = intervalBoundaries[i];
            }
            data.put("mappingDurationFrequencies", durationFrequencies);
            this.prepareJsonResponse(res);
            res.getWriter().write(JsonUtil.toJson(data));
        }
    }

    private void prepareJsonResponse(HttpServletResponse res) {
        res.setCharacterEncoding("UTF-8");
        res.setContentType("application/json; charset=UTF-8");
    }

    private void provideStatisticsOfAllModels(HttpServletResponse res) throws IOException {
        LinkedList<Map<String, Object>> data = new LinkedList<Map<String, Object>>();
        for (ResourceModelMetaData metaData : this.modelMetaDataRegistrar.get()) {
            data.add(this.toMap(metaData));
        }
        this.prepareJsonResponse(res);
        res.getWriter().write(JsonUtil.toJson(data));
    }

    private Map<String, Object> toMap(ResourceModelMetaData metaData) {
        ResourceModelStatistics statistics = metaData.getStatistics();
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        int lazyFields = 0;
        int greedyFields = 0;
        for (MappedFieldMetaData field : metaData.getMappableFields()) {
            boolean isLazyLoadedField;
            boolean bl = isLazyLoadedField = field.isLazy() || field.isChildrenAnnotationPresent() || field.isReference() && field.isInstantiableCollectionType();
            if (isLazyLoadedField) {
                ++lazyFields;
                continue;
            }
            ++greedyFields;
        }
        data.put("type", metaData.getTypeName());
        data.put("since", statistics.getSince());
        data.put("mappableFields", metaData.getMappableFields().length);
        data.put("lazyFields", lazyFields);
        data.put("greedyFields", greedyFields);
        data.put("instantiations", statistics.getInstantiations());
        data.put("mappings", statistics.getNumberOfMappings());
        data.put("averageMappingDuration", statistics.getAverageMappingDuration());
        data.put("totalMappingDuration", statistics.getTotalMappingDuration());
        data.put("maximumMappingDuration", statistics.getMaximumMappingDuration());
        data.put("minimumMappingDuration", statistics.getMinimumMappingDuration());
        data.put("mappingDurationMedian", statistics.getMappingDurationMedian());
        data.put("cacheHits", statistics.getCacheHits());
        return data;
    }

    protected void renderContent(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.writeHeadnavigation(res);
        this.writeBody(res);
    }

    public URL getResource(String path) {
        URL url = null;
        String internalPath = StringUtils.substringAfter((String)path, (String)("/" + this.getLabel()));
        if (StringUtils.startsWith((CharSequence)internalPath, (CharSequence)"/static/")) {
            url = ((Object)((Object)this)).getClass().getResource("/META-INF/consoleplugin/modelstatistics" + internalPath);
        }
        return url;
    }

    private void writeHeadnavigation(HttpServletResponse response) throws IOException {
        int numberOfModelsWithInstantiations = 0;
        double highestAverageMappingDuration = 0.0;
        int highestNumberOfFields = 0;
        String nameOfModelWithHighestAverageMappingDuration = "";
        String nameOfModelWithGreatestNumberOfFields = "";
        for (ResourceModelMetaData metaData : this.modelMetaDataRegistrar.get()) {
            int numberOfMappableFields;
            ResourceModelStatistics statistics = metaData.getStatistics();
            if (statistics.getInstantiations() == 0L) continue;
            ++numberOfModelsWithInstantiations;
            double averageMappingDuration = statistics.getAverageMappingDuration();
            if (averageMappingDuration > highestAverageMappingDuration) {
                highestAverageMappingDuration = averageMappingDuration;
                nameOfModelWithHighestAverageMappingDuration = metaData.getTypeName();
            }
            if ((numberOfMappableFields = metaData.getMappableFields().length) <= highestNumberOfFields) continue;
            highestNumberOfFields = numberOfMappableFields;
            nameOfModelWithGreatestNumberOfFields = metaData.getTypeName();
        }
        String template = this.readTemplateFile("/META-INF/consoleplugin/modelstatistics/templates/head.html");
        response.getWriter().printf(template, numberOfModelsWithInstantiations, Math.round(highestAverageMappingDuration), nameOfModelWithHighestAverageMappingDuration, highestNumberOfFields, nameOfModelWithGreatestNumberOfFields);
    }

    private void writeBody(HttpServletResponse response) throws IOException {
        String template = this.readTemplateFile("/META-INF/consoleplugin/modelstatistics/templates/plots.html");
        response.getWriter().print(template);
    }
}

