/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.metadata;

import io.neba.api.annotations.Unmapped;
import io.neba.core.resourcemodels.metadata.MappedFieldMetaData;
import io.neba.core.resourcemodels.metadata.MethodMetaData;
import io.neba.core.resourcemodels.metadata.ResourceModelStatistics;
import io.neba.core.util.Annotations;
import io.neba.core.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.apache.commons.lang3.reflect.FieldUtils;

public class ResourceModelMetaData {
    private final MappedFieldMetaData[] mappableFields;
    private final MethodMetaData[] afterMappingMethods;
    private final String typeName;
    private final ResourceModelStatistics statistics = new ResourceModelStatistics();

    public ResourceModelMetaData(Class<?> modelType) {
        FieldMetadataCreator fc = new FieldMetadataCreator(modelType);
        FieldUtils.getAllFieldsList(modelType).forEach(fc);
        MethodMetadataCreator mc = new MethodMetadataCreator();
        ReflectionUtil.methodsOf(modelType).stream().filter(m -> !m.getDeclaringClass().isInterface() || Modifier.isAbstract(m.getModifiers())).forEach(mc);
        this.mappableFields = fc.getMappableFields();
        this.afterMappingMethods = mc.getAfterMappingMethods();
        this.typeName = modelType.getName();
    }

    public MappedFieldMetaData[] getMappableFields() {
        return this.mappableFields;
    }

    public MethodMetaData[] getAfterMappingMethods() {
        return this.afterMappingMethods;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public ResourceModelStatistics getStatistics() {
        return this.statistics;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getTypeName() + ']';
    }

    private static class FieldMetadataCreator
    implements Consumer<Field> {
        private final Deque<MappedFieldMetaData> mappableFields = new LinkedList<MappedFieldMetaData>();
        private final Class<?> modelType;

        FieldMetadataCreator(Class<?> modelType) {
            if (modelType == null) {
                throw new IllegalArgumentException("Constructor parameter modelType must not be null.");
            }
            this.modelType = modelType;
        }

        @Override
        public void accept(Field field) {
            if (this.isMappingCandidate(field)) {
                MappedFieldMetaData fieldMetaData = new MappedFieldMetaData(field, this.modelType);
                this.mappableFields.addFirst(fieldMetaData);
            }
        }

        private MappedFieldMetaData[] getMappableFields() {
            return this.mappableFields.toArray(new MappedFieldMetaData[this.mappableFields.size()]);
        }

        private boolean isMappingCandidate(Field field) {
            return !this.isStatic(field) && !this.isFinal(field) && !this.isUnmapped(field);
        }

        private boolean isFinal(Field field) {
            return Modifier.isFinal(field.getModifiers());
        }

        private boolean isStatic(Field field) {
            return Modifier.isStatic(field.getModifiers());
        }

        private boolean isUnmapped(Field field) {
            Annotations annotations = Annotations.annotations(field);
            return annotations.contains(Unmapped.class) || annotations.containsName("javax.inject.Inject") || annotations.containsName("org.springframework.beans.factory.annotation.Autowired") || annotations.containsName(Resource.class.getName());
        }
    }

    private static class MethodMetadataCreator
    implements Consumer<Method> {
        private final Collection<MethodMetaData> afterMappingMethods = new ArrayList<MethodMetaData>(32);

        private MethodMetadataCreator() {
        }

        @Override
        public void accept(Method method) {
            MethodMetaData methodMetaData = new MethodMetaData(method);
            if (methodMetaData.isAfterMappingCallback()) {
                this.afterMappingMethods.add(methodMetaData);
            }
        }

        private MethodMetaData[] getAfterMappingMethods() {
            return this.afterMappingMethods.toArray(new MethodMetaData[this.afterMappingMethods.size()]);
        }
    }
}

