/*
 * Decompiled with CFR 0.152.
 */
package io.neba.core.resourcemodels.metadata;

import io.neba.core.resourcemodels.metadata.ResourceModelMetaData;
import io.neba.core.util.OsgiModelSource;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={ResourceModelMetaDataRegistrar.class})
public class ResourceModelMetaDataRegistrar {
    private Map<Class<?>, ResourceModelMetadataHolder> cache = new HashMap(512);

    public Collection<ResourceModelMetaData> get() {
        return this.cache.values().stream().map(holder -> ((ResourceModelMetadataHolder)holder).metaData).collect(Collectors.toList());
    }

    public ResourceModelMetaData get(Class<?> modelType) {
        if (modelType == null) {
            throw new IllegalArgumentException("Method argument modelType must not be null.");
        }
        ResourceModelMetadataHolder metaDataHolder = this.cache.get(modelType);
        if (metaDataHolder == null) {
            metaDataHolder = this.cache.get(this.getUserClass(modelType));
        }
        if (metaDataHolder == null) {
            throw new IllegalStateException("Unable to obtain resource model metadata for " + modelType + " - this type was either never registered or has been removed, i.e.  it's source bundle was uninstalled.");
        }
        return metaDataHolder.metaData;
    }

    public void register(OsgiModelSource<?> modelSource) {
        if (modelSource == null) {
            throw new IllegalArgumentException("method parameter modelSource must not be null");
        }
        Class<?> modelType = modelSource.getModelType();
        ResourceModelMetaData modelMetaData = new ResourceModelMetaData(modelType);
        ResourceModelMetadataHolder holder = new ResourceModelMetadataHolder(modelSource, modelMetaData);
        Map<Class<?>, ResourceModelMetadataHolder> newCache = this.copyCache();
        newCache.put(this.getUserClass(modelType), holder);
        this.cache = newCache;
    }

    public void removeMetadataForModelsIn(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("method parameter bundle must not be null");
        }
        Map<Class<?>, ResourceModelMetadataHolder> newCache = this.copyCache();
        Iterator<Map.Entry<Class<?>, ResourceModelMetadataHolder>> it = newCache.entrySet().iterator();
        while (it.hasNext()) {
            OsgiModelSource source = it.next().getValue().source;
            if (source.getBundleId() != bundle.getBundleId()) continue;
            it.remove();
        }
        this.cache = newCache;
    }

    private Map<Class<?>, ResourceModelMetadataHolder> copyCache() {
        return new HashMap(this.cache);
    }

    private Class<?> getUserClass(Class<?> type) {
        Class<?> superclass;
        if (type.getName().contains("$$") && (superclass = type.getSuperclass()) != null && Object.class != superclass) {
            return superclass;
        }
        return type;
    }

    @Deactivate
    protected void deactivate() {
        this.cache.clear();
    }

    private static class ResourceModelMetadataHolder {
        private final OsgiModelSource<?> source;
        private final ResourceModelMetaData metaData;

        private ResourceModelMetadataHolder(OsgiModelSource<?> source, ResourceModelMetaData metaData) {
            this.source = source;
            this.metaData = metaData;
        }
    }
}

